% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{sample_n}
\alias{sample_n}
\alias{sample_n.Seurat}
\alias{sample_frac}
\alias{sample_frac.Seurat}
\title{Sample n rows from a table}
\usage{
\method{sample_n}{Seurat}(tbl, size, replace = FALSE, weight = NULL, .env = NULL, ...)

\method{sample_frac}{Seurat}(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...)
}
\arguments{
\item{tbl}{A data.frame.}

\item{size}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>
For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{.env}{DEPRECATED.}

\item{...}{ignored}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
\code{sample_n()} and \code{sample_frac()} have been superseded in favour of
\code{\link[dplyr:slice_sample]{slice_sample()}}. While they will not be deprecated in the near future,
retirement means that we will only perform critical bug fixes, so we recommend
moving to the newer alternative.

These functions were superseded because we realised it was more convenient to
have two mutually exclusive arguments to one function, rather than two
separate functions. This also made it to clean up a few other smaller
design issues with \code{sample_n()}/\code{sample_frac}:
\itemize{
\item The connection to \code{slice()} was not obvious.
\item The name of the first argument, \code{tbl}, is inconsistent with other
single table verbs which use \code{.data}.
\item The \code{size} argument uses tidy evaluation, which is surprising and
undocumented.
\item It was easier to remove the deprecated \code{.env} argument.
\item \code{...} was in a suboptimal position.
}
}
\examples{
data(pbmc_small)
pbmc_small |> sample_n(50)
pbmc_small |> sample_frac(0.1)

}
