% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxnet_fit.R
\name{maxnet_fit}
\alias{maxnet_fit}
\title{Wrapper to fit maxnet models with formulae}
\usage{
maxnet_fit(
  formula,
  data,
  regmult = 1,
  classes = "default",
  regfun = maxnet::maxnet.default.regularization,
  addsamplestobackground = TRUE,
  ...
)
}
\arguments{
\item{formula}{a formula defining the outcome and the predictors}

\item{data}{a data.frame with the outcomes and predictors}

\item{regmult}{numeric, a constant to adjust regularization}

\item{classes}{character, continuous feature classes desired, either
"default" or any subset of "lqpht" (for example, "lh")}

\item{regfun}{function, computes regularization constant for each feature}

\item{addsamplestobackground}{logical, if TRUE then add to the background any
presence sample that is not already there}

\item{...}{currently not used.}
}
\value{
Maxnet returns an object of class \code{maxnet}, which is a list
consisting of a glmnet model with the following elements added:
\describe{
\item{betas}{ nonzero coefficients of the fitted model }
\item{alpha}{ constant offset making the exponential model sum to one
over the background data }
\item{entropy}{ entropy of the exponential model }
\item{penalty.factor}{ the regularization constants used for each feature }
\item{featuremins}{ minimum of each feature, to be used for clamping }
\item{featuremaxs}{ maximum of each feature, to be used for clamping }
\item{varmin}{ minimum of each predictor, to be used for clamping }
\item{varmax}{ maximum of each predictor, to be used for clamping }
\item{samplemeans}{ mean of each predictor over samples (majority for
factors) }
\item{levels}{ levels of each predictor that is a factor }
}
}
\description{
This function is a wrapper around \link[maxnet:maxnet]{maxnet::maxnet}, which takes a formula
with data as well exposing parameters for normalisation in a manner
compatible with \code{parsnip}. Users are unlikely to use this function directly.
For the \code{parsnip} model specification for MaxEnt, see \code{\link[=maxent]{maxent()}}.
}
\details{
The response needs to be a factor with the class representing presences as
the reference level of the factor (as expected by other classification
models). A good guide to how options of a Maxent model work can be found in
https://onlinelibrary.wiley.com/doi/full/10.1111/j.1600-0587.2013.07872.x
}
\examples{
# we repeat the example in the `maxnet` package
data("bradypus", package = "maxnet")
bradypus_tb <- tibble::as_tibble(bradypus) \%>\%
  dplyr::mutate(presence = relevel(
    factor(
      dplyr::case_match(presence, 1 ~ "presence", 0 ~ "absence")
    ),
    ref = "presence"
  ))
mod <- maxnet_fit(presence ~ ., data = bradypus_tb, classes = "lq")
plot(mod, "tmp6190_ann")
}
\keyword{internal}
