% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-summarise.R
\name{summarise_by_time}
\alias{summarise_by_time}
\alias{summarize_by_time}
\title{Summarise each group by time}
\usage{
summarise_by_time(
  .data,
  .date_var,
  ...,
  .by = "week",
  .type = c("floor", "ceiling", "round")
)

summarize_by_time(
  .data,
  .date_var,
  ...,
  .by = "week",
  .type = c("floor", "ceiling", "round")
)
}
\arguments{
\item{.data}{A \code{tbl} object or \code{data.frame}}

\item{.date_var}{A column of date or date-time (e.g. POSIXct) data class}

\item{...}{Name-value pairs of summary functions.
The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A vector of length \code{n}, e.g. \code{quantile()}.
\item A data frame, to add multiple columns from a single expression.
}}

\item{.by}{A time unit to summarise by.
Time units are collapsed using \code{lubridate::floor_date()} or \code{lubridate::ceiling_date()}.

The value can be:
\itemize{
\item \code{second}
\item \code{minute}
\item \code{hour}
\item \code{day}
\item \code{week}
\item \code{month}
\item \code{bimonth}
\item \code{quarter}
\item \code{season}
\item \code{halfyear}
\item \code{year}
}

Arbitrary unique English abbreviations as in the \code{lubridate::period()} constructor are allowed.}

\item{.type}{One of "floor", "ceiling", or "round. Defaults to "floor". See \code{lubridate::round_date}.}
}
\value{
An object \emph{usually} of the same type as \code{.data}.
\itemize{
\item The rows come from the underlying \code{group_keys()}.
\item The columns are a combination of the grouping keys and the summary
expressions that you provide.
\item If \code{x} is grouped by more than one variable, the output will be another
\link{grouped_df} with the right-most group removed.
\item If \code{x} is grouped by one variable, or is not grouped, the output will
be a \link{tibble}.
\item Data frame attributes are \strong{not} preserved, because \code{summarise()}
fundamentally creates a new data frame.
}
}
\description{
\code{summarise_by_time()} Is a time-series variant of the popular \code{dplyr::summarise()} function.

\code{summarise_by_time()} and \code{summarize_by_time()} are synonyms.
}
\section{Useful summary functions}{

\itemize{
\item Sum: \code{\link[=SUM]{SUM()}}
\item Center: \code{\link[=AVERAGE]{AVERAGE()}}, \code{\link[=MEDIAN]{MEDIAN()}}
\item Spread: \code{\link[=STDEV]{STDEV()}}, \code{\link[=VAR]{VAR()}}
\item Range: \code{\link[=MIN]{MIN()}}, \code{\link[=MAX]{MAX()}}
\item Count: \code{\link[=COUNT]{COUNT()}}, \code{\link[=COUNT_UNIQUE]{COUNT_UNIQUE()}}
\item Position: \code{\link[=FIRST]{FIRST()}}, \code{\link[=LAST]{LAST()}}, \code{\link[=NTH]{NTH()}}
\item Correlation: \code{\link[=COR]{COR()}}, \code{\link[=COV]{COV()}}
}
}

\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.
}

\examples{
# Libraries
library(tidyquant)
library(dplyr)

# First adjusted price in each month
FANG \%>\%
    group_by(symbol) \%>\%
    summarise_by_time(
        .date_var  = date,
        .by         = "month",
        adjusted   = FIRST(adjusted)
    )

# Last adjused price in each month (day is last day of month with ceiling option)
FANG \%>\%
    group_by(symbol) \%>\%
    summarise_by_time(
        .date_var  = date,
        .by        = "month",
        adjusted   = LAST(adjusted),
        .type      = "ceiling")

# Total Volume each year (.by is set to "year" now)
FANG \%>\%
    group_by(symbol) \%>\%
    summarise_by_time(
        .date_var  = date,
        .by        = "year",
        adjusted   = SUM(volume))


}
\concept{single table verbs}
