% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_as_geno_lea.R
\name{gt_as_geno_lea}
\alias{gt_as_geno_lea}
\title{Convert a \code{gentibble} to a .geno file for sNMF from the LEA package}
\usage{
gt_as_geno_lea(x, file = NULL)
}
\arguments{
\item{x}{a \code{\link{gen_tibble}}}

\item{file}{the .geno filename with a path, or NULL (the default) to use the
location of the backing files.}
}
\value{
the path of the .geno file
}
\description{
This function writes a .geno file from a \code{\link{gen_tibble}}. Unless a file path
is given, a file with suffix .geno is written in the same location as the
.rds and .bk files that underpin the \code{\link{gen_tibble}}.
}
\details{
NOTE that we currently read all the data into memory to write the file, so
this function is not suitable for very large datasets.
}
\examples{
\dontshow{if (rlang::is_installed("LEA")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
example_gt <- load_example_gt("gen_tbl")

# Write a geno file
gt_as_geno_lea(example_gt, file = paste0(tempfile(), "_example.geno"))
\dontshow{\}) # examplesIf}
}
