% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust_x_axis}
\alias{adjust_x_axis}
\alias{adjust_y_axis}
\title{Adjust axes}
\usage{
adjust_x_axis(
  plot,
  title = ggplot2::waiver(),
  breaks = ggplot2::waiver(),
  labels = ggplot2::waiver(),
  limits = NULL,
  padding = c(NA, NA),
  rotate_labels = FALSE,
  transform = "identity",
  cut_short_scale = FALSE,
  force_continuous = FALSE,
  ...
)

adjust_y_axis(
  plot,
  title = ggplot2::waiver(),
  breaks = ggplot2::waiver(),
  labels = ggplot2::waiver(),
  limits = NULL,
  padding = c(NA, NA),
  rotate_labels = FALSE,
  transform = "identity",
  cut_short_scale = FALSE,
  force_continuous = FALSE,
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{title}{Axis title.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{Axis limits. For example, with \code{limits = c(20, 90)} the axis starts at 20 and ends at 90.}

\item{padding}{Extra space between the data points and the axes. Defaults to \code{c(NA, NA)}, which does not change the padding.}

\item{rotate_labels}{Whether to rotate axis labels. If \code{TRUE} is set to 45 degrees. You can also provide custom degree values, for example, \code{rotate_labels = 90}. Defaults to \code{FALSE}.}

\item{transform}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{transform_<name>}. If
transformations require arguments, you can call them from the scales
package, e.g. \code{\link[scales:transform_boxcox]{scales::transform_boxcox(p = 2)}}.
You can create your own transformation with \code{\link[scales:new_transform]{scales::new_transform()}}.}

\item{cut_short_scale}{Whether to shorten axis labels using \code{K} for thousand, \code{M} for million, and so on. Defaults to \code{FALSE}.}

\item{force_continuous}{Whether to force the axis to be continuous. Defaults to \code{FALSE}.}

\item{...}{Arguments passed on to ggplot2 \code{scale} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Adjust axes
}
\details{
\itemize{
\item The \code{title} argument of \code{adjust_x_axis()} and \code{adjust_y_axis()} supports \href{https://www.rdocumentation.org/packages/grDevices/versions/3.6.2/topics/plotmath}{plotmath expressions} to include special characters.
See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#special-characters}{Advanced plotting}.
}
}
\examples{
# Plot without adjustments
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points()

# New titles
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points() \%>\%
  adjust_x_axis(title = "My new x-axis title") \%>\%
  adjust_y_axis(title = "My new y-axis title")

# New titles with plotmath expressions
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points() \%>\%
  adjust_x_axis(title = "$H[2]*O$") \%>\%
  adjust_y_axis(title = "$E==m*c^{2}$")

# Axes limits
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points() \%>\%
  adjust_x_axis(limits = c(-1000, 4000)) \%>\%
  adjust_y_axis(limits = c(-200, 600))

# Rotate labels
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points() \%>\%
  adjust_x_axis(rotate_labels = 90) \%>\%
  adjust_y_axis(rotate_labels = 90)

# Increase plot area padding
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points() \%>\%
  adjust_x_axis(padding = c(0.2, 0.2)) \%>\%
  adjust_y_axis(padding = c(0.2, 0.2))

# Scale transformation
animals \%>\%
  tidyplot(x = weight, y = size, color = family) \%>\%
  add_data_points() \%>\%
  adjust_x_axis(transform = "log10") \%>\%
  adjust_y_axis(transform = "log2")

}
