% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{predict_gam}
\alias{predict_gam}
\title{Get predictions from a GAM model.}
\usage{
predict_gam(
  model,
  exclude_terms = NULL,
  length_out = 50,
  values = NULL,
  type = "link"
)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names should be given as they appear in the model summary (for example, \code{"s(x0,x1)"}).}

\item{length_out}{An integer indicating how many values along the numeric predictors to use for predicting the outcome term (the default is \code{50}).}

\item{values}{User supplied values for specific terms as a named list. If the value is \code{NULL}, the first value of the term is selected (useful when excluding terms).}

\item{type}{Either \code{"link"} or \code{"terms"}. See Details below.}
}
\value{
A tibble with predictions from a \link[mgcv:gam]{gam} or \link[mgcv:bam]{bam} model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This function is from the superseded package tidymv. Please, use the tidygam
package instead.

It returns a tibble with the predictions from all the terms in a \link[mgcv:gam]{gam} or \link[mgcv:bam]{bam} model.

If you simply want to return a tibble with the predicted values of the
response/outcome variable based on all terms (minus excluded smooth terms),
set \code{type = "link"} (the default). Note that if \code{type = "link"},
parametric terms cannot be excluded from the prediction, due to limitations
of \code{mgcv}. If you want to return a tibble with the predicted values of
the response/outcome variable for each term in the model separately, set
\code{type = "terms"}. This type can be helpful if you want more flexibility
in plotting.
}
\examples{
\dontrun{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ fac + s(x2) + s(x2, by = fac) + s(x0), data = data)

# get predictions
p <- predict_gam(model)

# get predictions excluding x0 (the coefficient of x0 is set to 0);
# setting the value for the excluded term to NULL with the argument 'values'
# reduces computation time
p_2 <- predict_gam(model, exclude_terms = "s(x0)", values = list(x0 = NULL))

# get predictions with chosen values of x0

p_3 <- predict_gam(model, values = list(x0 = c(0.250599, 0.503313, 0.756028)))
}
}
