% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_verbs.R
\name{fetch_batch}
\alias{fetch_batch}
\title{Fetch Results from a Batch API}
\usage{
fetch_batch(
  .llms,
  .provider = getOption("tidyllm_fbatch_default"),
  .dry_run = NULL,
  .max_tries = NULL,
  .timeout = NULL
)
}
\arguments{
\item{.llms}{A list of \code{LLMMessage} objects containing conversation histories.}

\item{.provider}{A function or function call specifying the language model provider and any additional parameters.
This should be a call to a provider function like \code{openai()}, \code{claude()}, etc.
You can also set a default provider function via the \code{tidyllm_fbatch_default} option.}

\item{.dry_run}{Logical; if \code{TRUE}, returns the constructed request without executing it}

\item{.max_tries}{Integer; maximum number of retries if the request fails}

\item{.timeout}{Integer; request timeout in seconds}
}
\value{
A list of updated \code{LLMMessage} objects, each with the assistant's response added if successful.
}
\description{
This function retrieves the results of a completed  batch and updates
the provided list of \code{LLMMessage} objects with the responses. It aligns each
response with the original request using the \code{custom_id}s generated in \code{send_batch()}.
}
\details{
The function routes the input to the appropriate provider-specific batch API function.
}
