% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inftheo.R
\name{shannon_cond_entropy}
\alias{shannon_cond_entropy}
\title{Conditional Shannon Entropy H(X|Y) i.e. "H(X given Y)"}
\usage{
shannon_cond_entropy(.data, ..., na.rm = FALSE)
}
\arguments{
\item{.data}{A tibble with the columns of interest}

\item{...}{two columns (variables) selected (order is important)}

\item{na.rm}{remove all rows with NA values in at least one of the columns}
}
\value{
a double with the calculated value
}
\description{
This calculates conditional shannon entropy of two columns in a tibble.
It's assumed these columns are character typed with no NAs.
}
\examples{
# make an all-character version of mtchars
mt_tib <- as_tibble(mtcars) \%>\% mutate_all(as.character)
shannon_cond_entropy(mt_tib, vs, am)
shannon_cond_entropy(mt_tib, 'vs', 'am')
shannon_cond_entropy(mt_tib, starts_with('c'))
shannon_cond_entropy(mt_tib, 9:8)
}
\seealso{
\link{shannon_entropy}
}
