% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_types}
\alias{node_types}
\alias{node_is_cut}
\alias{node_is_root}
\alias{node_is_leaf}
\alias{node_is_sink}
\alias{node_is_source}
\alias{node_is_isolated}
\alias{node_is_universal}
\alias{node_is_simplical}
\alias{node_is_center}
\alias{node_is_keyplayer}
\title{Querying node types}
\usage{
node_is_cut()

node_is_root()

node_is_leaf()

node_is_sink()

node_is_source()

node_is_isolated()

node_is_universal(mode = "out")

node_is_simplical(mode = "out")

node_is_center(mode = "out")

node_is_keyplayer(k, p = 0, tol = 1e-04, maxsec = 120, roundsec = 30)
}
\arguments{
\item{mode}{The way edges should be followed in the case of directed graphs.}

\item{k}{The number of keyplayers to identify}

\item{p}{The probability to accept a lesser state}

\item{tol}{Optimisation tolerance, below which the optimisation will stop}

\item{maxsec}{The total computation budget for the optimization, in seconds}

\item{roundsec}{Number of seconds in between synchronizing workers' answer}
}
\value{
A logical vector of the same length as the number of nodes in the
graph.
}
\description{
These functions all lets the user query whether each node is of a certain
type. All of the functions returns a logical vector indicating whether the
node is of the type in question. Do note that the types are not mutually
exclusive and that nodes can thus be of multiple types.
}
\section{Functions}{
\itemize{
\item \code{node_is_cut}: is the node a cut node (articaultion node)

\item \code{node_is_root}: is the node a root in a tree

\item \code{node_is_leaf}: is the node a leaf in a tree

\item \code{node_is_sink}: does the node only have incomming edges

\item \code{node_is_source}: does the node only have outgoing edges

\item \code{node_is_isolated}: is the node unconnected

\item \code{node_is_universal}: is the node connected to all other nodes in the graph

\item \code{node_is_simplical}: are all the neighbors of the node connected

\item \code{node_is_center}: does the node have the minimal eccentricity in the graph

\item \code{node_is_keyplayer}: Is a node part of the keyplayers in the graph (\code{influenceR})
}}

\examples{
# Find the root and leafs in a tree
create_tree(40, 2) \%>\%
  mutate(root = node_is_root(), leaf = node_is_leaf())
}
