% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_bunch.R
\name{tidy_bunch}
\alias{tidy_bunch}
\title{Tidy Gapminder indices data sheets stored in a folder
using \code{\link{tidy_indice}}.}
\usage{
tidy_bunch(dirpath = ".", merge = FALSE, ...)
}
\arguments{
\item{dirpath}{Absolute path to folder containing indices
data sheets.}

\item{merge}{A boolean. If true, combines all indices data sheets
in one. Default: FALSE.}

\item{...}{Ellipsis.}
}
\value{
List of indices data frames tidied (if \code{merge} = FALSE)
   or a single data frame of all indices tidied
   (if \code{merge} = TRUE).
}
\description{
Tidy Gapminder indices data sheets stored in a folder
using \code{\link{tidy_indice}}.
}
\examples{

folder_path <- system.file("extdata/gapminder", package = "tidygapminder")

tidy_bunch(folder_path)

}
