% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest.R
\name{nest}
\alias{nest}
\alias{unnest}
\alias{squeeze}
\alias{chop}
\alias{unchop}
\title{Nest and unnest}
\usage{
nest(.data, ..., mcols = NULL, .name = "ndt")

unnest(.data, ...)

squeeze(.data, ..., .name = "ndt")

chop(.data, ...)

unchop(.data, ...)
}
\arguments{
\item{.data}{data.table, nested or unnested}

\item{...}{The variables for nest group(for \code{nest}),
columns to be nested(for \code{squeeze} and \code{chop}),
or column(s) to be unnested(for \code{unnest}).
Could recieve anything that \code{\link[tidyfst]{select_dt}} could receive.}

\item{mcols}{Name-variable pairs in the list, form like}

\item{.name}{Character. The nested column name. Defaults to "ndt".
\code{list(petal="^Pe",sepal="^Se")}, see example.}
}
\value{
data.table, nested or unnested
}
\description{
Analogous function for \code{nest} and \code{unnest} in \pkg{tidyr}.
\code{unnest} will automatically remove other list-columns except for the
target list-columns (which would be unnested later). Also, \code{squeeze} is
designed to merge multiple columns into list column.
}
\details{
In the \code{nest}, the data would be nested to a column named `ndt`,
 which is short for nested data.table.

The \code{squeeze} would not remove the originial columns.

The \code{unchop} is the reverse operation of \code{chop}.

These functions are experiencing the experimental stage, especially
the \code{unnest}. If they don't work on some circumtances, try \pkg{tidyr}
package.
}
\examples{

mtcars = as.data.table(mtcars)
iris = as.data.table(iris)

# examples for nest

# nest by which columns?
 mtcars \%>\% nest(cyl)
 mtcars \%>\% nest("cyl")
 mtcars \%>\% nest(cyl,vs)
 mtcars \%>\% nest(vs:am)
 mtcars \%>\% nest("cyl|vs")
 mtcars \%>\% nest(c("cyl","vs"))

# nest two columns directly
iris \%>\% nest(mcols = list(petal="^Pe",sepal="^Se"))

# nest more flexibly
iris \%>\% nest(mcols = list(ndt1 = 1:3,
  ndt2 = "Pe",
  ndt3 = Sepal.Length:Sepal.Width))

# examples for unnest
# unnest which column?
 mtcars \%>\% nest("cyl|vs") \%>\%
   unnest(ndt)
 mtcars \%>\% nest("cyl|vs") \%>\%
   unnest("ndt")

df <- data.table(
  a = list(c("a", "b"), "c"),
  b = list(c(TRUE,TRUE),FALSE),
  c = list(3,c(1,2)),
  d = c(11, 22)
)

df
df \%>\% unnest(a)
df \%>\% unnest(2)
df \%>\% unnest("c")
df \%>\% unnest(cols = names(df)[3])

# You can unnest multiple columns simultaneously
df \%>\% unnest(1:3)
df \%>\% unnest(a,b,c)
df \%>\% unnest("a|b|c")

# examples for squeeze
# nest which columns?
iris \%>\% squeeze(1:2)
iris \%>\% squeeze("Se")
iris \%>\% squeeze(Sepal.Length:Petal.Width)

# examples for chop
df <- data.table(x = c(1, 1, 1, 2, 2, 3), y = 1:6, z = 6:1)
df \%>\% chop(y,z)
df \%>\% chop(y,z) \%>\% unchop(y,z)
}
\references{
https://www.r-bloggers.com/much-faster-unnesting-with-data-table/

https://stackoverflow.com/questions/25430986/create-nested-data-tables-by-collapsing-rows-into-new-data-tables
}
\seealso{
\code{\link[tidyr]{nest}}, \code{\link[tidyr]{chop}}
}
