% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{sample_dt}
\alias{sample_dt}
\alias{sample_n_dt}
\alias{sample_frac_dt}
\title{Sample rows randomly from a table}
\usage{
sample_dt(.data, n = NULL, prop = NULL, replace = FALSE, by = NULL)

sample_n_dt(.data, size, replace = FALSE, by = NULL)

sample_frac_dt(.data, size, replace = FALSE, by = NULL)
}
\arguments{
\item{.data}{A data.frame}

\item{n}{Number of rows to select}

\item{prop}{Fraction of rows to select}

\item{replace}{Sample with or without replacement? Default uses \code{FALSE}.}

\item{by}{(Optional) Character. Specify if you want to sample by group.}

\item{size}{For \code{sample_n_dt}, the number of rows to select.
For \code{sample_frac_dt}, the fraction of rows to select.}
}
\value{
data.table
}
\description{
Select a number or proportion of rows randomly from the data frame

\code{sample_dt} is a merged version of \code{sample_n_dt} and
\code{sample_frac_dt}, this could be convenient.
}
\examples{
sample_n_dt(mtcars, 10)
sample_n_dt(mtcars, 50, replace = TRUE)
sample_frac_dt(mtcars, 0.1)
sample_frac_dt(mtcars, 1.5, replace = TRUE)


sample_dt(mtcars,n=10)
sample_dt(mtcars,prop = 0.1)


# sample by group(s)
iris \%>\% sample_n_dt(2,by = "Species")
iris \%>\% sample_frac_dt(.1,by = "Species")

mtcars \%>\% sample_n_dt(1,by = c("cyl","vs"))
}
\seealso{
\code{\link[dplyr]{sample_n}},\code{\link[dplyr]{sample_frac}}
}
