% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_utils.R
\name{add_title}
\alias{add_title}
\title{Add IBCS complient legend}
\usage{
add_title(svg_string, line1, line2_measure, line2_rest, line3 = "")
}
\arguments{
\item{svg_string}{one element character vector containing SVG graphic statements. Legend will be added to this plot.}

\item{line1}{first line of title. Element(s) of the structure dimension represent the object of the report, typically a legal entity, an organization unit, or a line of business}

\item{line2_measure}{First part of second line of the title. It wil be in bold text. It should represent buisness measure being analyzed.}

\item{line2_rest}{Second part of second line of the title. It should represent units of measure.}

\item{line3}{Third line of the title, it should indicate time, scenarios, variances, etc}
}
\value{
one element character vector containing SVG graphic statements. svg_string with appended legend.
}
\description{
Add IBCS complient legend
}
\examples{
df <- data.frame(x = 2010:2015, sales = rnorm(6,10, 2))
column_chart(df, df$x, 'sales') \%>\%
  add_title(line1 = 'Department of Big Computers',
    line2_measure = "Sales",
    line2_rest = "in mEUR",
    line3 = "2010..2015") \%>\%
  SVGrenderer()

}
