% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.summary.mc}
\alias{print.summary.mc}
\title{Print the summarized results of a Monte Carlo Simulation}
\usage{
\method{print}{summary.mc}(x, ...)
}
\arguments{
\item{x}{An object of class \code{summary.mc}}

\item{...}{ignored}
}
\value{
print shows a nice representation of the
summarized results of a Monte Carlo Simulation
}
\description{
Print the summarized results of a Monte Carlo Simulation run by \code{\link[=future_mc]{future_mc()}}
and summarized by \code{\link[=summary.mc]{summary.mc()}}
}
\examples{

test_func <- function(param = 0.1, n = 100, x1 = 1, x2 = 2){

  data <- rnorm(n, mean = param) + x1 + x2
  stat <- mean(data)
  stat_2 <- var(data)

  if (x2 == 5){
    stop("x2 can't be 5!")
  }

  return(list(mean = stat, var = stat_2))
}

param_list <- list(param = seq(from = 0, to = 1, by = 0.5),
                   x1 = 1:2)

set.seed(101)
test_mc <- future_mc(
  fun = test_func,
  repetitions = 1000,
  param_list = param_list,
  n = 10,
  x2 = 2
)

summary(test_mc)
}
