% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{compare_solutions_mplus-deprecated}
\alias{compare_solutions_mplus-deprecated}
\title{Explore fit statistics various models and numbers of profiles using MPlus (requires purchasing and installing MPlus to use)}
\usage{
compare_solutions_mplus(...)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles_min}{lower bound of the number of profiles to explore; defaults to 2}

\item{n_profiles_max}{upper bound of the number of profiles to explore; defaults to 10}

\item{models}{which models to include as a list of vectors; for each vector, the first value represents how the variances are estimated and the second value represents how the covariances are estimated; defaults to list(c("equal", "zero"), c("varying", "zero"), c("equal", "equal"), c("varying", "varying"))}

\item{cluster_ID}{clustering variable to use as part of MPlus 'type is complex' command}

\item{save_models}{whether to save the models as rds files}

\item{return_table}{logical (TRUE or FALSE) for whether to return a table of the output instead of a plot; defaults to TRUE}

\item{return_stats_df}{whether to return a list of fit statistics for the solutions explored; defaults to TRUE}

\item{dir_name}{character; name for directory .out files are saved to if save_models = TRUE; defaults to the present date}

\item{idvar}{optional name of the column to be used as the ID variable (should be supplied as a string). Defaults to \code{NULL}, in which case row numbers will be used. Note the ID can be numeric or string, but must be unique.}

\item{data_filename}{name of data file to prepare; defaults to d.dat}

\item{script_filename}{name of script to prepare; defaults to i.inp}

\item{output_filename}{name of the output; defaults to o.out}

\item{savedata_filename}{name of the output for the save data (with the original data conditional probabilities); defaults to o-mod.out}

\item{starts}{number of initial stage starts and number of final stage optimizations; defaults to c(20, 4); can be set to be more conservative to c(500, 50)}

\item{m_iterations}{number of iterations for the EM algorithm; defaults to 500}

\item{st_iterations}{the number of initial stage iterations; defaults to 10; can be set more to be more conservative to 50}

\item{convergence_criterion}{convergence criterion for the Quasi-Newton algorithm for continuous outcomes; defaults to 1E-6 (.000001); can be set more conservatively to 1E-7 (.0000001)}

\item{remove_tmp_files}{whether to remove data, script, and output files; defaults to TRUE}

\item{print_input_file}{whether to print the input file to the console}

\item{return_save_data}{whether to return the save data (with the original data and the posterior probabilities for the classes and the class assignment) as a data.frame along with the MPlus output; defaults to TRUE}

\item{optseed}{random seed for analysis}

\item{cluster_ID}{clustering variable (i.e., if data are from students clustered into distinct classrooms) to be used as cluster variables as part of the type = complex option}

\item{include_VLMR}{whether to include the Vu-Lo-Mendell-Rubin likelihood-ratio test; defaults to TRUE}

\item{include_BLRT}{whether to include the bootstrapped LRT; defaults to FALSE because of the time this takes to run}

\item{n_processors}{= 1}

\item{return_all_stats}{defaults to FALSE; if TRUE, returns as a one-row data frame all of the statistics returned from compare_solutions_mplus()}
}
\value{
a list with a data.frame with the BIC values and a list with all of the model output; if save_models is the name of an rds file (i.e., "out.rds"), then the model output will be written with that filename and only the data.frame will be returned
}
\description{
Explore fit statistics various models and numbers of profiles using MPlus (requires purchasing and installing MPlus to use)
}
\details{
Explore the BIC values of a range of Mplus models in terms of a) the structure of the residual covariance matrix and b) the number of mixture components (or profiles)
}
\seealso{
\code{\link{tidyLPA-deprecated}}
}
\keyword{internal}
