% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_profiles.R
\name{plot_profiles}
\alias{plot_profiles}
\title{Plot profile centroids}
\usage{
plot_profiles(x, to_center = F, to_scale = F, plot_what = "tibble",
  plot_error_bars = TRUE)
}
\arguments{
\item{x}{output from create_profiles_mclust()}

\item{to_center}{whether to center the data before plotting}

\item{to_scale}{whether to scale the data before plotting}

\item{plot_what}{whether to plot tibble or mclust output from estimate_profiles(); defaults to tibble}

\item{plot_error_bars}{whether to plot error bars (representing the 95 percent confidence interval for the mean of each variable)}
}
\description{
Plot profile centroids
}
\details{
Plot the centroids for tibble or mclust output from estimate_profiles()
}
\examples{
m3 <- estimate_profiles(iris,
    Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
    model = 1,
    n_profiles = 3)
plot_profiles(m3)
}
