% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bde_parse_dates}
\alias{bde_parse_dates}
\title{Parse dates}
\usage{
bde_parse_dates(dates_to_parse)
}
\arguments{
\item{dates_to_parse}{Dates to parse}
}
\value{
A class "Date" object.
}
\description{
Tries to parse strings representing dates using \code{\link[=as.Date]{as.Date()}}
}
\note{
This function is tailored for the date formatting used on this package, so
it may fail if it is used for another datasets. See examples for checking
which formats would be considered.
}
\examples{
# Formats parsed
would_parse <- c(
  "02 FEB2019", "MAR 2020", "ENE2020", "2020",
  "12-1993", "01-02-2014", "01/02/1990"
)

parsed_ok <- bde_parse_dates(would_parse)

class(parsed_ok)

tibble::tibble(raw = would_parse, parsed = parsed_ok)

#-----------------------------------

# Formats not admitted
wont_parse <- c("JAN2001", "2010-01-12", "01 APR 2017", "01/31/1990")

parsed_fail <- bde_parse_dates(wont_parse)

class(parsed_fail)

tibble::tibble(raw = wont_parse, parsed = parsed_fail)
}
\seealso{
\code{\link[=as.Date]{as.Date()}}
}
\concept{utils}
