% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-tree.R
\name{unnest_tree}
\alias{unnest_tree}
\title{Unnest a recursive data frame}
\usage{
unnest_tree(
  data,
  id_col,
  child_col,
  level_to = "level",
  parent_to = "parent",
  ancestors_to = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{id_col}{A column that uniquely identifies each observation.}

\item{child_col}{Column containing the children of an observation. This must
be a list where each element is either \code{NULL} or a data frame with the same
columns as \code{data}.}

\item{level_to}{A string (\code{"level"} by default) specifying the new column to
store the level of an observation. Use \code{NULL} if you don't need this
information.}

\item{parent_to}{A string (\code{"parent"} by default) specifying the new column
storing the parent id of an observation. Use \code{NULL} if you don't need this
information.}

\item{ancestors_to}{A string (\code{NULL} by default) specifying the new column
storing the ids of its ancestors. Use \code{NULL} if you don't need this
information.}
}
\value{
A data frame.
}
\description{
Unnest a recursive data frame
}
\examples{
df <- tibble(
  id = 1L,
  name = "a",
  children = list(
    tibble(
      id = 11:12,
      name = c("b", "c"),
      children = list(
        NULL,
        tibble(
          id = 121:122,
          name = c("d", "e")
        )
      )
    )
  )
)

unnest_tree(
  df,
  id_col = "id",
  child_col = "children",
  level_to = "level",
  parent_to = "parent",
  ancestors_to = "ancestors"
)
}
