% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_brain.R, R/fs_brain2.R
\name{freesurfer_brain}
\alias{freesurfer_brain}
\alias{freesurfer_brain2}
\title{Read `FreeSurfer` surface and volume files}
\usage{
freesurfer_brain(
  fs_subject_folder,
  subject_name,
  additional_surfaces = NULL,
  aligned_ct = NULL,
  use_cache = TRUE,
  use_141 = getOption("threeBrain.use141", TRUE)
)

freesurfer_brain2(
  fs_subject_folder,
  subject_name,
  volume_types = "t1",
  surface_types = "pial",
  curvature = "sulc",
  use_cache = TRUE,
  use_141 = getOption("threeBrain.use141", TRUE),
  ...
)
}
\arguments{
\item{fs_subject_folder}{character, `FreeSurfer` subject folder, or `RAVE` subject folder}

\item{subject_name}{character, subject code to display with only letters and digits}

\item{additional_surfaces}{character array, additional surface types to load, such as `white`, `smoothwm`}

\item{aligned_ct}{character, path to `ct_aligned_mri.nii.gz`, used for electrode localization}

\item{use_cache}{logical, whether to use cached `json` files or from raw `FreeSurfer` files}

\item{use_141}{logical, whether to use standard 141 brain for surface file, default is \code{getOption('threeBrain.use141', TRUE)}}

\item{volume_types}{volume types, right now only support T1 image}

\item{surface_types}{surface types to load}

\item{curvature}{curvature data. Only support \code{"sulc"} for current version}

\item{...}{ignored}
}
\description{
Read `FreeSurfer` surface and volume files
}
\details{
This function is under FreeSurfer license.
1. Volumes:
3D viewer uses `mri/T1.mgz` from `FreeSurfer` to show the
volume information. `T1.mgz` results from step 1 to 5 in `FreeSurfer`
command `recon-all -autorecon1`, which aligns the original `DICOM` image to `RAS` coordinate
system, resamples to volume with \code{256x256x256} voxels (tri-linear by default,
check \url{https://surfer.nmr.mgh.harvard.edu/fswiki/recon-all}
for more information).

2. Surface:
There are two options for surface files. The first choice is using
`std.141` brain generated by `AFNI/SUMA`. This surface file re-calculates vertices
from standard 141 space, which averages the "surface" of 141 subjects. If you
want to map surface electrodes across different subjects, you might want to
consider this case as it's especially designed for surface mapping. However,
you'll need `AFNI/SUMA` installed to generate the surface file. The details
can be found via \url{https://openwetware.org/wiki/Beauchamp:CorticalSurfaceHCP},
and the `AFNI/SUMA` command related is `SurfToSurf`. Please generate the files
to `[FREESURFER SUBJECT DIR]/SUMA/`. The file name follows the convention of
`std.141.[lr]h.[SURFACE TYPE].[POSTFIX]`, where `lh` means left hemisphere and
`rh` means right hemisphere; `SURFACE TYPE` can be `pial`, `white`, `smoothwm`,
and `POSTFIX` can be `asc`, `gii`. If multiple files for the same surface
type exists, the search order will be `asc > gii`.
The other option is to use mesh files directly from `FreeSurfer` output located
at `[FREESURFER SUBJECT DIR]/surf`. If you want to use these surface, make sure
they are converted to `asc` or `gii` format.

3. Electrode registration and transforms
This package provides two ways to map electrodes to standard space. For surface
electrodes, if standard 141 brain is provided, then the first option is to snap
electrodes to the nearest vertices in subject space. The key is the vertex number
matches across different subjects, hence the location of corresponding vertices
at template brain are the mapped electrode coordinates.
If standard 141 brain is missing, or the electrode type is `stereo EEG`, then
the second option is volume mapping. The idea is to map electrodes to `MNI305`
brain. The details can be found at \url{https://surfer.nmr.mgh.harvard.edu/fswiki/CoordinateSystems}.
To perform volume mapping, we need `FreeSurfer` folder `mri/transforms`.
Currently, only linear `Talairach` transform matrix is supported (located at
`talairach.xfm`).

4. Coordinates
The 3D viewer in this package uses the center of volume as the origin (0, 0, 0).
}
\examples{
\donttest{
# Please run `download_N27()` if `N27` is not at '~/rave_data/others/three_brain/'

# Import from `FreeSurfer` subject folder
brain = threeBrain::freesurfer_brain(
  fs_subject_folder = '~/rave_data/others/three_brain/N27/', subject_name = 'N27',
  additional_surfaces = c('white', 'smoothwm')
)

# Visualize. Alternatively, you can use brain$plot(...)
plot( brain )
}
}
\author{
Zhengjia Wang
}
