% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_top_features.R
\name{compute_top_features}
\alias{compute_top_features}
\title{Return an object containing results from top-performing features on a classification task}
\usage{
compute_top_features(
  data,
  id_var = "id",
  group_var = "group",
  num_features = 40,
  normalise_violin_plots = FALSE,
  method = c("z-score", "Sigmoid", "RobustSigmoid", "MinMax"),
  cor_method = c("pearson", "spearman"),
  test_method = "gaussprRadial",
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  use_balanced_accuracy = FALSE,
  use_k_fold = FALSE,
  num_folds = 10,
  use_empirical_null = FALSE,
  null_testing_method = c("model free shuffles", "null model fits"),
  p_value_method = c("empirical", "gaussian"),
  num_permutations = 50,
  pool_empirical_null = FALSE,
  seed = 123
)
}
\arguments{
\item{data}{the dataframe containing the raw feature matrix}

\item{id_var}{a string specifying the ID variable to group data on (if one exists). Defaults to \code{"id"}}

\item{group_var}{a string specifying the grouping variable that the data aggregates to. Defaults to \code{"group"}}

\item{num_features}{the number of top features to retain and explore. Defaults to \code{40}}

\item{normalise_violin_plots}{a Boolean of whether to normalise features before plotting. Defaults to \code{FALSE}}

\item{method}{a rescaling/normalising method to apply. Defaults to \code{"RobustSigmoid"}}

\item{cor_method}{the correlation method to use. Defaults to \code{"pearson"}}

\item{test_method}{the algorithm to use for quantifying class separation. Defaults to \code{"gaussprRadial"}}

\item{clust_method}{the hierarchical clustering method to use for the pairwise correlation plot. Defaults to \code{"average"}}

\item{use_balanced_accuracy}{a Boolean specifying whether to use balanced accuracy as the summary metric for caret model training. Defaults to \code{FALSE}}

\item{use_k_fold}{a Boolean specifying whether to use k-fold procedures for generating a distribution of classification accuracy estimates if a \code{caret} model is specified for \code{test_method}. Defaults to \code{ FALSE}}

\item{num_folds}{an integer specifying the number of k-folds to perform if \code{use_k_fold} is set to \code{TRUE}. Defaults to \code{10}}

\item{use_empirical_null}{a Boolean specifying whether to use empirical null procedures to compute p-values if a \code{caret} model is specified for \code{test_method}. Defaults to \code{FALSE}}

\item{null_testing_method}{a string specifying the type of statistical method to use to calculate p-values. Defaults to \code{model free shuffles}}

\item{p_value_method}{a string specifying the method of calculating p-values. Defaults to \code{"empirical"}}

\item{num_permutations}{an integer specifying the number of class label shuffles to perform if \code{use_empirical_null} is \code{TRUE}. Defaults to \code{50}}

\item{pool_empirical_null}{a Boolean specifying whether to use the pooled empirical null distribution of all features or each features' individual empirical null distribution if a \code{caret} model is specified for \code{test_method} use_empirical_null is \code{TRUE}. Defaults to \code{FALSE}}

\item{seed}{fixed number for R's random number generator to ensure reproducibility}
}
\value{
an object of class list containing a dataframe of results, a feature x feature matrix plot, and a violin plot
}
\description{
Return an object containing results from top-performing features on a classification task
}
\examples{
\donttest{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)
  
compute_top_features(featMat,
  id_var = "id",
  group_var = "group",
  num_features = 10,
  normalise_violin_plots = FALSE,
  method = "RobustSigmoid",
  cor_method = "pearson",
  test_method = "gaussprRadial",
  clust_method = "average",
  use_balanced_accuracy = FALSE,
  use_k_fold = FALSE,
  num_folds = 10,
  use_empirical_null = TRUE,
  null_testing_method = "model free shuffles",
  p_value_method = "gaussian",
  num_permutations = 100,
  pool_empirical_null = FALSE,
  seed = 123) 
}

}
\author{
Trent Henderson
}
