% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modelling.R
\name{lscomb}
\alias{lscomb}
\title{Lowering Stress by comparing combinations (lscomb)}
\usage{
lscomb(data, points, method = "as", single = TRUE, comments = FALSE,
  type = "ordinal", weight = TRUE)
}
\arguments{
\item{data}{Dataset; the first column must be the ID of the unit of comparison, 
the other columns must be categories; see dataset requirements \code{simi}.}

\item{points}{Number of categories that should be included in the model 
(p < n, wherein n equals the number of categories in the dataset).}

\item{method}{Specifies the similarity index used to compute the similarity 
matrix, choose between "\code{as}" (Association Strength Index), 
"\code{jaccard}" (Jaccard  Index), "\code{cosine}" (Cosine Index), 
and "\code{inclusion}" (Inclusion Index). Default is \code{as}.}

\item{single}{If \code{TRUE}, single mentionings (i.e. one respondent 
mentioning just one category) are included when calculating the similarity 
matrix. Default is \code{TRUE}.}

\item{comments}{If \code{TRUE}, comments relating to exclusion or possible 
exclusion of categories and respondents are displayed. Default is 
\code{FALSE}.}

\item{type}{Specifies the type of MDS model used (for more details see
 the package '\code{smacof}' of Mair, De Leeuw, Borg, & Groenen). Default is
\code{ordinal}.}

\item{weight}{If \code{TRUE}, the MDS model is calcualted using weights, 
i.e., similarities of zero are excluded. Default is \code{TRUE}.}
}
\value{
Matrix showing the categories included and the Stress values of the 
respective MDS models.
}
\description{
\code{lscomb} calculates Stress levels for all combinations of p out of 
n categories
}
\details{
This function is applicable to co-occurrence data. It shows the resulting 
Stress values for all combinations of p out of n categories. The output 
consists in a table showing which categories have been included and the 
resulting Stress values. The table is sorted such that the lowest Stress 
level occurs at the top. The MDS model is computed using the package 
'\code{smacof}' (Mair, De Leeuw, Borg, & Groenen). The first column of the 
input matrix \code{data} should contain the ID of the unit of comparison 
and the following columns the categories for which the similarity matrices 
and MDS maps are calculated (see also the description of \code{simi}). Note 
that the purpose of this function is to assist modeling by helping to 
identify potential problems. It is not, however, meant to be used for 
excluding categories based solely on measures of fit and without substantial 
justification.
}
\examples{
## Calculate Stress values for 5 out of 7 SDGs
data(SDG_coocurrence)
SDG_coocurrence <- SDG_coocurrence[,-2] # Drop second column
input <- SDG_coocurrence[,1:8] # For computational reasons, we will work 
                               # with 7 SDGs.  
stress <- lscomb(input, points = 5)
stress
}
\seealso{
\code{\link[smacof]{smacofSym}} for details on calculating MDS 
 representations, \code{\link[thectar]{simi}} for details on calculating  
 similarity matrices.
}
