% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page_plan.R
\name{page_plan}
\alias{page_plan}
\title{Page Plan}
\usage{
page_plan(
  ...,
  note_loc = c("noprint", "preheader", "subtitle", "source_note"),
  max_rows = NULL
)
}
\arguments{
\item{...}{a series of \code{\link[=page_structure]{page_structure()}} separated by commas}

\item{note_loc}{Location of the note describing each table's subset value(s).
Useful if the \code{page_structure} contains only ".default" values (meaning the
table is split by every unique level of a grouping variable), and that
variable is dropped in the col_plan. \code{preheader} only available for rtf output.}

\item{max_rows}{Option to set a maximum number of rows per page. Takes a numeric value.}
}
\value{
page_plan object
}
\description{
Defining the location and/or frequency of page splits with a series of
page_structure's and the row_every_n argument, respectively.
}
\examples{
 # use of page_struct
 page_plan(
    page_structure(group_val = "grp1", label_val = "lbl1")
 )

 # use of #  rows
 page_plan(
    max_rows = 5
 )


}
