% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_dataset.R
\name{kinesis_dataset}
\alias{kinesis_dataset}
\title{Creates a \code{KinesisDataset}.}
\usage{
kinesis_dataset(stream, shard = "", read_indefinitely = TRUE,
  interval = 1e+05)
}
\arguments{
\item{stream}{A \code{tf.string} tensor containing the name of the stream.}

\item{shard}{A \code{tf.string} tensor containing the id of the shard.}

\item{read_indefinitely}{If \code{True}, the Kinesis dataset will keep retry again
on \code{EOF} after the \code{interval} period. If \code{False}, then the dataset will
stop on \code{EOF}. The default value is \code{True}.}

\item{interval}{The interval for the Kinesis Client to wait before it tries
to get records again (in millisecond).}
}
\description{
Kinesis is a managed service provided by AWS for data streaming.
This dataset reads messages from Kinesis with each message presented
as a \code{tf.string}.
}
