% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfb-class.R
\name{tfb}
\alias{tfb}
\alias{tfb_wavelet}
\alias{as.tfb}
\title{Constructors for functional data in basis representation}
\usage{
tfb(data = data.frame(), basis = c("spline", "fpc", "wavelet"), ...)

tfb_wavelet(data, ...)

as.tfb(data, basis = c("spline", "fpc"), ...)
}
\arguments{
\item{data}{a \code{matrix}, \code{data.frame} or \code{list} of suitable shape, or another
\code{tf}-object containing functional data.}

\item{basis}{either "\code{spline}" (see \code{\link[=tfb_spline]{tfb_spline()}}, the default) or "\code{fpc}"
(see \code{\link[=tfb_fpc]{tfb_fpc()}}).
(\code{wavelet} not implemented yet)}

\item{...}{further arguments for \code{\link[=tfb_spline]{tfb_spline()}} or \code{\link[=tfb_fpc]{tfb_fpc()}}}
}
\value{
a \code{tfb}-object (or a \code{data.frame}/\code{matrix} for the conversion
functions, obviously.)
}
\description{
Various constructors for \code{tfb}-vectors from different kinds of inputs.
}
\details{
\code{tfb} is a wrapper for functions that set up spline-, principal component- or
wavelet-based representations of functional data. For all three, the input
data \eqn{x_i(t)} are represented as weighted sums of a set of common basis
functions \eqn{B_k(t); k = 1,\dots, K} identical for all observations and
weight or coefficient vectors \eqn{b_i = (b_{i1}, \dots, b_{iK})} estimated
for each observation: \eqn{x_i(t) \approx \sum_k B_k(t) b_{ik}}. Depending on
the value of \code{basis}, the basis functions \eqn{B(t)} will either be \code{spline}
functions or the first few estimated eigenfunctions of the covariance
operator of the \eqn{x(t)} (\code{fpc}) or wavelets (\code{wavelet}).

See \strong{\code{\link[=tfb_spline]{tfb_spline()}}} for more details on spline basis representation (the
default). See \strong{\code{\link[=tfb_fpc]{tfb_fpc()}}} for using an functional principal component
representation with an orthonormal basis estimated from the data instead.
}
\seealso{
Other tfb-class: 
\code{\link{fpc_wsvd}()},
\code{\link{tfb_fpc}()},
\code{\link{tfb_spline}()}

Other tfb-class: 
\code{\link{fpc_wsvd}()},
\code{\link{tfb_fpc}()},
\code{\link{tfb_spline}()}
}
\concept{tfb-class}
