% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration}
\alias{duration}
\alias{duration.data.frame}
\alias{duration.default}
\alias{duration.numeric}
\alias{ends}
\alias{starts}
\title{Duration of Turns of Talk}
\usage{
duration(x, ...)

\method{duration}{default}(x, grouping.var = NULL, ...)

\method{duration}{data.frame}(x, text.var = TRUE, ...)

\method{duration}{numeric}(x, ...)

starts(x, ...)

ends(x, ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with a text
variable or a numeric vector.}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates
one word list for all text.  Also takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{text.var}{The name of the text variable.  If \code{TRUE}
\code{duration} tries to detect the text column.}

\item{\ldots}{Ignored.}
}
\value{
Returns a vector or data frame of starts and/or ends.
}
\description{
\code{duration} - Calculate duration (start and end times) for duration of turns
of talk measured in words.

\code{startss} - Calculate start times from a numeric vector.

\code{ends} - Calculate end times from a numeric vector.
}
\examples{
(x <- c(
    "Mr. Brown comes! He says hello. i give him coffee.",
    "I'll go at 5 p. m. eastern time.  Or somewhere in between!",
    "go there"
))
duration(x)
group <- c("A", "B", "A")
duration(x, group)

groups <- list(group1 = c("A", "B", "A"), group2 = c("red", "red", "green"))
duration(x, groups)

data(DATA)
duration(DATA)

## Larger data set
duration(hamlet)

## Integer values
x <- sample(1:10, 10)
duration(x)
starts(x)
ends(x)
}

