% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_candidates.R
\name{pairwise_candidates}
\alias{pairwise_candidates}
\title{Candidate pairs from pairwise comparisons}
\usage{
pairwise_candidates(m, directional = FALSE)
}
\arguments{
\item{m}{A matrix from \code{\link{pairwise_compare}}.}

\item{directional}{Should be set to the same value as in
\code{\link{pairwise_compare}}.}
}
\value{
A data frame containing all the non-\code{NA} values from \code{m}.
  Columns \code{a} and \code{b} are the IDs from the original corpus as
  passed to the comparison function. Column \code{score} is the score
  returned by the comparison function.
}
\description{
Converts a comparison matrix generated by \code{\link{pairwise_compare}} into a
data frame of candidates for matches.
}
\examples{
dir <- system.file("extdata/legal", package = "textreuse")
corpus <- TextReuseCorpus(dir = dir)

m1 <- pairwise_compare(corpus, ratio_of_matches, directional = TRUE)
pairwise_candidates(m1, directional = TRUE)

m2 <- pairwise_compare(corpus, jaccard_similarity)
pairwise_candidates(m2)
}

