% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cluster_frequency}
\alias{cluster_frequency}
\title{Frequencies of an existing cluster object}
\usage{
cluster_frequency(tokenized_list_text, cluster_vector, verbose = FALSE)
}
\arguments{
\item{tokenized_list_text}{a list of tokenized text documents. This can be the result of the \emph{textTinyR::tokenize_transform_vec_docs} function with the \emph{as_token} parameter set to TRUE (the \emph{token} object of the output)}

\item{cluster_vector}{a numeric vector. This can be the result of the \emph{ClusterR::KMeans_rcpp} function (the \emph{clusters} object of the output)}

\item{verbose}{either TRUE or FALSE. If TRUE then information will be printed out in the R session.}
}
\value{
a list of data.tables
}
\description{
Frequencies of an existing cluster object
}
\details{
This function takes a list of tokenized text and a numeric vector of clusters and returns the sorted frequency of each cluster. The length of the \emph{tokenized_list_text} object must be equal to the length of the \emph{cluster_vector} object
}
\examples{

library(textTinyR)

tok_lst = list(c('the', 'the', 'tokens', 'of', 'first', 'document'),
               c('the', 'tokens', 'of', 'of', 'second', 'document'),
               c('the', 'tokens', 'of', 'third', 'third', 'document'))

vec_clust = rep(1:6, 3)

res = cluster_frequency(tok_lst, vec_clust)
}
