% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_1_textEmbed.R
\name{textDimName}
\alias{textDimName}
\title{Change dimension names}
\usage{
textDimName(word_embeddings, dim_names = TRUE)
}
\arguments{
\item{word_embeddings}{List of word embeddings}

\item{dim_names}{(boolean) If TRUE the word embedding name will be attached to the name of each dimension;
is FALSE, the attached part of the name will be removed.}
}
\value{
Word embeddings with changed names.
}
\description{
textDimName() changes the names of the dimensions in the word embeddings.
}
\examples{
\donttest{
# Note that dimensions are called Dim1_harmonytexts etc.
word_embeddings_4$texts$harmonytexts
# Here they are changed to just Dim
w_e_T <- textDimName(word_embeddings_4$texts["harmonytexts"],
  dim_names = FALSE
)
# Here they are changed back
w_e_F <- textDimName(w_e_T, dim_names = TRUE)
}
}
\seealso{
see \code{\link{textEmbed}}
}
