% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{expect_snapshot}
\alias{expect_snapshot}
\title{Snapshot testing}
\usage{
expect_snapshot(
  x,
  cran = FALSE,
  error = FALSE,
  transform = NULL,
  variant = NULL,
  cnd_class = FALSE
)
}
\arguments{
\item{x}{Code to evaluate.}

\item{cran}{Should these expectations be verified on CRAN? By default,
they are not, because snapshot tests tend to be fragile because they
often rely on minor details of dependencies.}

\item{error}{Do you expect the code to throw an error? The expectation
will fail (even on CRAN) if an unexpected error is thrown or the
expected error is not thrown.}

\item{transform}{Optionally, a function to scrub sensitive or stochastic
text from the output. Should take a character vector of lines as input
and return a modified character vector as output.}

\item{variant}{If non-\code{NULL}, results will be saved in
\verb{_snaps/\{variant\}/\{test.md\}}, so \code{variant} must be a single string
suitable for use as a directory name.

You can use variants to deal with cases where the snapshot output varies
and you want to capture and test the variations. Common use cases include
variations for operating system, R version, or version of key dependency.
Variants are an advanced feature. When you use them, you'll need to
carefully think about your testing strategy to ensure that all important
variants are covered by automated tests, and ensure that you have a way
to get snapshot changes out of your CI system and back into the repo.}

\item{cnd_class}{Whether to include the class of messages,
warnings, and errors in the snapshot. Only the most specific
class is included, i.e. the first element of \code{class(cnd)}.}
}
\description{
Snapshot tests (aka golden tests) are similar to unit tests except that the
expected result is stored in a separate file that is managed by testthat.
Snapshot tests are useful for when the expected value is large, or when
the intent of the code is something that can only be verified by a human
(e.g. this is a useful error message). Learn more in
\code{vignette("snapshotting")}.

\code{expect_snapshot()} runs code as if you had executed it at the console, and
records the results, including output, messages, warnings, and errors.
If you just want to compare the result, try \code{\link[=expect_snapshot_value]{expect_snapshot_value()}}.
}
\section{Workflow}{

The first time that you run a snapshot expectation it will run \code{x},
capture the results, and record them in \verb{tests/testthat/_snaps/\{test\}.md}.
Each test file gets its own snapshot file, e.g. \code{test-foo.R} will get
\verb{_snaps/foo.md}.

It's important to review the Markdown files and commit them to git. They are
designed to be human readable, and you should always review new additions
to ensure that the salient information has been captured. They should also
be carefully reviewed in pull requests, to make sure that snapshots have
updated in the expected way.

On subsequent runs, the result of \code{x} will be compared to the value stored
on disk. If it's different, the expectation will fail, and a new file
\verb{_snaps/\{test\}.new.md} will be created. If the change was deliberate,
you can approve the change with \code{\link[=snapshot_accept]{snapshot_accept()}} and then the tests will
pass the next time you run them.

Note that snapshotting can only work when executing a complete test file
(with \code{\link[=test_file]{test_file()}}, \code{\link[=test_dir]{test_dir()}}, or friends) because there's otherwise
no way to figure out the snapshot path. If you run snapshot tests
interactively, they'll just display the current value.
}

