% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_test_context}
\alias{local_test_context}
\alias{local_reproducible_output}
\title{Locally set options for maximal test reproducibility}
\usage{
local_test_context(.env = parent.frame())

local_reproducible_output(
  width = 80,
  crayon = FALSE,
  unicode = FALSE,
  .env = parent.frame()
)
}
\arguments{
\item{.env}{Environment to use for scoping; expert use only.}

\item{width}{Value of the \code{"width"} option.}

\item{crayon}{Value of the \code{"crayon.enabled"} option.}

\item{unicode}{Value of the \code{"cli.unicode"} option.
The test is skipped if \code{l10n_info()$`UTF-8`} is \code{FALSE}.}
}
\description{
\code{local_test_context()} is run automatically by \code{test_that()} but you may
want to run it yourself if you want to replicate test results interactively.
If run inside a function, the effects are automatically reversed when the
function exits; if running in the global environment, use
\code{\link[withr:defer]{withr::deferred_run()}} to undo.

\code{local_reproducible_output()} is run automatically by \code{test_that()} in the
3rd edition. You might want to call it to override the the default settings
inside a test, if you want to test Unicode and coloured output or
non-standard width.
}
\details{
\code{local_test_context()} and \code{local_reproducible_output()}
set the following options with \code{\link[withr:with_options]{withr::local_options()}}:
\itemize{
\item \code{cli.unicode} (default: \code{FALSE}) so that the cli package never generates unicode
output (normally cli uses unicode on Linux/Mac but not Windows).
Windows can't easily save unicode output to disk, so it must be set to
false for consistency.
\item \code{crayon.enabled} (default: \code{FALSE}) suppresses ANSI colours generated by the crayon
package (normally colours are used if crayon detects that you're in a
terminal that supports colour).
\item \code{width} (default: 80) to control the width of printed output (usually this
varies with the size of your console).
}

In addition, \code{local_test_context()} sets the following options:
\itemize{
\item \code{cli.dynamic = FALSE} so that tests assume that they are not run in
a dynamic console (i.e. one where you can move the cursor around).
\item \code{lifecycle_verbosity = "warning"} so that every lifecycle problem always
generates a warning (otherwise deprecated functions don't generate a
warning every time).
\item \code{OutDec = "."} so numbers always uses \code{.} as the decimal point
(European users sometimes set \code{OutDec = ","}.)
\item \code{rlang_interactive = FALSE} so that \code{\link[rlang:is_interactive]{rlang::is_interactive()}} returns
\code{FALSE}, and code that uses it assumes you're in a non-interactive
environment.
\item \code{useFancyQuotes = FALSE} so base R functions always use regular (straight)
quotes (otherwise the default is locale dependent, see \code{\link[=sQuote]{sQuote()}} for
details).
}

\code{local_test_context()} also sets envvars \code{RSTUDIO = 0} (which ensures that RStudio is never
detected as running), and \code{TESTTHAT = "true"} (which ensures that
\code{\link[=is_testing]{is_testing()}} returns \verb{TRUE)}, and sets collation locale to "C"
(which ensures that character sorting the same regardless of current
locale).
}
\examples{
local({
  local_test_context()
  cat(crayon::blue("Text will not be colored"))
  cat(cli::symbol$ellipsis)
  cat("\n")
})

ellipsis <- cli::symbol$ellipsis
test_that("test ellipsis", {
  expect_equal(ellipsis, cli::symbol$ellipsis)

  local_reproducible_output(unicode = TRUE)
  expect_equal(ellipsis, cli::symbol$ellipsis)
})
}
\keyword{internal}
