% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_depends.R
\name{expect_depends}
\alias{expect_depends}
\title{Expectations: functional dependency}
\usage{
expect_depends(vars, on, flt = TRUE, data = get_testdata())
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{on}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns which
\code{vars} are expected to depend on.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
Test whether one set of variables functionally depend on another set of
variables.
}
\details{
One set of variables, X, functionally depends on another, Y, if and only if
each value in Y corresponds to exactly one value in X. For instance,
\code{course_duration} and \code{course_topic} functionally depend on \code{course_code} if
each \code{course_code} corresponds to just one combination of \code{course_duration}
and \verb{course topic}. That is, if two records have the same \code{course_code} then
they must have the same \code{course_duration} and \code{course_topic}.

See the \href{https://en.wikipedia.org/wiki/Functional_dependency}{wikipedia page}
for more information.
}
\examples{

student_course <- data.frame(
  student_id = 1:5,
  course_code = c(1, 2, 1, 3, 4),
  course_duration = c(12, 12, 12, 12, 12),
  course_topic = c("Song", "Dance", "Song", "Painting", "Pottery")
)

# Check that each `course_code` corresponds to exactly one combination of
# `course_duration` and `course_topic`
expect_depends(
  c(course_duration, course_topic),
  on = course_code,
  data = student_course
)
}
\seealso{
Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
