#' @title Centric cuboctahedron
#' @description A cuboctahedron (12 vertices), with a point added at its center.
#'
#' @return A numeric matrix with 13 rows and 3 columns.
#' @export
centricCuboctahedron <- function(){
  rbind(
    c(-1, -1, 0),
    c(-1, 1, 0),
    c(1, -1, 0),
    c(1, 1, 0),
    c(-1, 0, -1),
    c(-1, 0, 1),
    c(1, 0, -1),
    c(1, 0, 1),
    c(0, -1, -1),
    c(0, -1, 1),
    c(0, 1, -1),
    c(0, 1, 1),
    c(0, 0, 0)
  )
}

#' @title Utah teapot
#' @description Vertices of the Utah teapot.
#'
#' @return A matrix with 1976 rows and 3 columns.
#' @export
teapot <- function(){
  rbind(
    c(-3, 1.64999997615814, 0),
    c(-2.98710989952087, 1.64999997615814, -0.0984380021691322),
    c(-2.98710989952087, 1.64999997615814, 0.0984380021691322),
    c(-2.98537993431091, 1.56731998920441, -0.0492190010845661),
    c(-2.98537993431091, 1.56731998920441, 0.0492190010845661),
    c(-2.9835000038147, 1.48308002948761, 0),
    c(-2.98188996315002, 1.72346997261047, -0.0492190010845661),
    c(-2.98188996315002, 1.72346997261047, 0.0492190010845661),
    c(-2.97656011581421, 1.79852998256683, 0),
    c(-2.97090005874634, 1.48620998859406, -0.0984380021691322),
    c(-2.97090005874634, 1.48620998859406, 0.0984380021691322),
    c(-2.96388006210327, 1.79533994197845, -0.0984380021691322),
    c(-2.96388006210327, 1.79533994197845, 0.0984380021691322),
    c(-2.96220993995667, 1.57017004489899, -0.133594006299973),
    c(-2.96220993995667, 1.57017004489899, 0.133594006299973),
    c(-2.95864009857178, 1.72056996822357, -0.133594006299973),
    c(-2.95864009857178, 1.72056996822357, 0.133594006299973),
    c(-2.95313000679016, 1.64999997615814, -0.168750002980232),
    c(-2.95313000679016, 1.64999997615814, 0.168750002980232),
    c(-2.95247006416321, 1.40374004840851, -0.0492190010845661),
    c(-2.95247006416321, 1.40374004840851, 0.0492190010845661),
    c(-2.93770003318787, 1.49447000026703, -0.168750002980232),
    c(-2.93770003318787, 1.49447000026703, 0.168750002980232),
    c(-2.93523001670837, 1.85214996337891, -0.0492190010845661),
    c(-2.93523001670837, 1.85214996337891, 0.0492190010845661),
    c(-2.93358993530273, 1.32011997699738, 0),
    c(-2.93044996261597, 1.78692996501923, -0.168750002980232),
    c(-2.93044996261597, 1.78692996501923, 0.168750002980232),
    c(-2.93037009239197, 1.41149997711182, -0.133594006299973),
    c(-2.93037009239197, 1.41149997711182, 0.133594006299973),
    c(-2.92188000679016, 1.32553005218506, -0.0984380021691322),
    c(-2.92188000679016, 1.32553005218506, 0.0984380021691322),
    c(-2.91278004646301, 1.84416997432709, -0.133594006299973),
    c(-2.91278004646301, 1.84416997432709, 0.133594006299973),
    c(-2.90625, 1.91015994548798, 0),
    c(-2.89422988891602, 1.90456998348236, -0.0984380021691322),
    c(-2.89422988891602, 1.90456998348236, 0.0984380021691322),
    c(-2.89138007164001, 1.57910001277924, -0.196875005960464),
    c(-2.89138007164001, 1.57910001277924, 0.196875005960464),
    c(-2.8909900188446, 1.33980000019073, -0.168750002980232),
    c(-2.8909900188446, 1.33980000019073, 0.168750002980232),
    c(-2.89065003395081, 1.71208000183105, -0.196875005960464),
    c(-2.89065003395081, 1.71208000183105, 0.196875005960464),
    c(-2.88346004486084, 1.24579000473022, -0.0483429990708828),
    c(-2.88346004486084, 1.24579000473022, 0.0483429990708828),
    c(-2.86346006393433, 1.25713002681732, -0.132717996835709),
    c(-2.86346006393433, 1.25713002681732, 0.132717996835709),
    c(-2.86265993118286, 1.43482995033264, -0.196875005960464),
    c(-2.86265993118286, 1.43482995033264, 0.196875005960464),
    c(-2.8625500202179, 1.88982999324799, -0.168750002980232),
    c(-2.8625500202179, 1.88982999324799, 0.168750002980232),
    c(-2.84999990463257, 1.64999997615814, -0.224999994039536),
    c(-2.84999990463257, 1.64999997615814, 0.224999994039536),
    c(-2.84970998764038, 1.16155004501343, 0),
    c(-2.84710001945496, 1.82081997394562, -0.196875005960464),
    c(-2.84710001945496, 1.82081997394562, 0.196875005960464),
    c(-2.84193992614746, 1.94692003726959, -0.0492190010845661),
    c(-2.84193992614746, 1.94692003726959, 0.0492190010845661),
    c(-2.8289999961853, 1.76139998435974, -0.224999994039536),
    c(-2.8289999961853, 1.76139998435974, 0.224999994039536),
    c(-2.82867002487183, 1.17597997188568, -0.0949330031871796),
    c(-2.82867002487183, 1.17597997188568, 0.0949330031871796),
    c(-2.82470011711121, 1.52193999290466, -0.224999994039536),
    c(-2.82470011711121, 1.52193999290466, 0.224999994039536),
    c(-2.82115006446838, 1.93519997596741, -0.133594006299973),
    c(-2.82115006446838, 1.93519997596741, 0.133594006299973),
    c(-2.81230998039246, 1.18719005584717, -0.168750002980232),
    c(-2.81230998039246, 1.18719005584717, 0.168750002980232),
    c(-2.80501008033752, 1.28997004032135, -0.196875005960464),
    c(-2.80501008033752, 1.28997004032135, 0.196875005960464),
    c(-2.79727005958557, 1.38311004638672, -0.224999994039536),
    c(-2.79727005958557, 1.38311004638672, 0.224999994039536),
    c(-2.78906011581421, 1.99013996124268, 0),
    c(-2.78836011886597, 1.69931995868683, -0.196875005960464),
    c(-2.78836011886597, 1.69931995868683, 0.196875005960464),
    c(-2.77820992469788, 1.98283004760742, -0.0984380021691322),
    c(-2.77820992469788, 1.98283004760742, 0.0984380021691322),
    c(-2.77442002296448, 1.52737998962402, -0.196875005960464),
    c(-2.77442002296448, 1.52737998962402, 0.196875005960464),
    c(-2.77356004714966, 1.09860002994537, -0.0843750014901161),
    c(-2.77356004714966, 1.09860002994537, 0.0843750014901161),
    c(-2.76641011238098, 1.84511995315552, -0.224999994039536),
    c(-2.76641011238098, 1.84511995315552, 0.224999994039536),
    c(-2.76033997535706, 1.90090000629425, -0.196875005960464),
    c(-2.76033997535706, 1.90090000629425, 0.196875005960464),
    c(-2.74959993362427, 1.96355998516083, -0.168750002980232),
    c(-2.74959993362427, 1.96355998516083, 0.168750002980232),
    c(-2.74831008911133, 1.78569996356964, -0.196875005960464),
    c(-2.74831008911133, 1.78569996356964, 0.196875005960464),
    c(-2.74688005447388, 1.64999997615814, -0.168750002980232),
    c(-2.74688005447388, 1.64999997615814, 0.168750002980232),
    c(-2.73125004768372, 1.00780999660492, 0),
    c(-2.72756004333496, 1.73587000370026, -0.168750002980232),
    c(-2.72756004333496, 1.73587000370026, 0.168750002980232),
    c(-2.72036004066467, 1.69082999229431, -0.133594006299973),
    c(-2.72036004066467, 1.69082999229431, 0.133594006299973),
    c(-2.71948003768921, 1.24977004528046, -0.224999994039536),
    c(-2.71948003768921, 1.24977004528046, 0.224999994039536),
    c(-2.71677994728088, 1.14468002319336, -0.196875005960464),
    c(-2.71677994728088, 1.14468002319336, 0.196875005960464),
    c(-2.71288990974426, 1.64999997615814, -0.0984380021691322),
    c(-2.71288990974426, 1.64999997615814, 0.0984380021691322),
    c(-2.7089900970459, 1.54176998138428, -0.133594006299973),
    c(-2.7089900970459, 1.54176998138428, 0.133594006299973),
    c(-2.70354008674622, 1.42640995979309, -0.168750002980232),
    c(-2.70354008674622, 1.42640995979309, 0.168750002980232),
    c(-2.70097994804382, 1.03784000873566, -0.168750002980232),
    c(-2.70097994804382, 1.03784000873566, 0.168750002980232),
    c(-2.70000004768372, 1.64999997615814, 0),
    c(-2.69965004920959, 2.0107901096344, -0.0483460016548634),
    c(-2.69965004920959, 2.0107901096344, 0.0483460016548634),
    c(-2.69711995124817, 1.68792998790741, -0.0492190010845661),
    c(-2.69711995124817, 1.68792998790741, 0.0492190010845661),
    c(-2.69412994384766, 1.72746002674103, -0.0984380021691322),
    c(-2.69412994384766, 1.72746002674103, 0.0984380021691322),
    c(-2.68661999702454, 1.54668998718262, -0.0492190010845661),
    c(-2.68661999702454, 1.54668998718262, 0.0492190010845661),
    c(-2.68263006210327, 1.76234996318817, -0.133594006299973),
    c(-2.68263006210327, 1.76234996318817, 0.133594006299973),
    c(-2.68147993087769, 1.9964599609375, -0.13272100687027),
    c(-2.68147993087769, 1.9964599609375, 0.13272100687027),
    c(-2.68144011497498, 1.72426998615265, 0),
    c(-2.67574000358582, 1.27084994316101, -0.196875005960464),
    c(-2.67574000358582, 1.27084994316101, 0.196875005960464),
    c(-2.67265009880066, 1.44068002700806, -0.0984380021691322),
    c(-2.67265009880066, 1.44068002700806, 0.0984380021691322),
    c(-2.67025995254517, 1.80040001869202, -0.168750002980232),
    c(-2.67025995254517, 1.80040001869202, 0.168750002980232),
    c(-2.667799949646, 1.84623003005981, -0.196875005960464),
    c(-2.667799949646, 1.84623003005981, 0.196875005960464),
    c(-2.66279006004333, 1.9050999879837, -0.224999994039536),
    c(-2.66279006004333, 1.9050999879837, 0.224999994039536),
    c(-2.66093993186951, 1.44608998298645, 0),
    c(-2.66018009185791, 1.75436997413635, -0.0492190010845661),
    c(-2.66018009185791, 1.75436997413635, 0.0492190010845661),
    c(-2.63858008384705, 1.78567004203796, -0.0984380021691322),
    c(-2.63858008384705, 1.78567004203796, 0.0984380021691322),
    c(-2.63438010215759, 1.10390996932983, -0.224999994039536),
    c(-2.63438010215759, 1.10390996932983, 0.224999994039536),
    c(-2.63073992729187, 1.95674002170563, -0.196875005960464),
    c(-2.63073992729187, 1.95674002170563, 0.196875005960464),
    c(-2.62655997276306, 1.78007996082306, 0),
    c(-2.625, 2.04375004768372, 0),
    c(-2.62463998794556, 1.30501997470856, -0.132813006639481),
    c(-2.62463998794556, 1.30501997470856, 0.132813006639481),
    c(-2.60642004013062, 1.31745004653931, -0.0484380014240742),
    c(-2.60642004013062, 1.31745004653931, 0.0484380014240742),
    c(-2.60631990432739, 2.02643990516663, -0.0949449986219406),
    c(-2.60631990432739, 2.02643990516663, 0.0949449986219406),
    c(-2.59179997444153, 2.01298999786377, -0.168750002980232),
    c(-2.59179997444153, 2.01298999786377, 0.168750002980232),
    c(-2.57172989845276, 1.83429002761841, -0.168750002980232),
    c(-2.57172989845276, 1.83429002761841, 0.168750002980232),
    c(-2.56777000427246, 1.16997003555298, -0.168750002980232),
    c(-2.56777000427246, 1.16997003555298, 0.168750002980232),
    c(-2.55460000038147, 1.18304002285004, -0.0953150019049644),
    c(-2.55460000038147, 1.18304002285004, 0.0953150019049644),
    c(-2.54975008964539, 1.89058995246887, -0.196875005960464),
    c(-2.54975008964539, 1.89058995246887, 0.196875005960464),
    c(-2.5495400428772, 0.878983974456787, -0.0843750014901161),
    c(-2.5495400428772, 0.878983974456787, 0.0843750014901161),
    c(-2.5464301109314, 1.83196997642517, -0.13272100687027),
    c(-2.5464301109314, 1.83196997642517, 0.13272100687027),
    c(-2.53749990463257, 1.20000004768372, 0),
    c(-2.52720999717712, 1.81920003890991, -0.0483460016548634),
    c(-2.52720999717712, 1.81920003890991, 0.0483460016548634),
    c(-2.51874995231628, 1.94530999660492, -0.224999994039536),
    c(-2.51874995231628, 1.94530999660492, 0.224999994039536),
    c(-2.51682996749878, 0.932671010494232, -0.196875005960464),
    c(-2.51682996749878, 0.932671010494232, 0.196875005960464),
    c(-2.47183990478516, 1.00648999214172, -0.196875005960464),
    c(-2.47183990478516, 1.00648999214172, 0.196875005960464),
    c(-2.44569993019104, 1.87764000892639, -0.168750002980232),
    c(-2.44569993019104, 1.87764000892639, 0.168750002980232),
    c(-2.43913006782532, 1.06017994880676, -0.0843750014901161),
    c(-2.43913006782532, 1.06017994880676, 0.0843750014901161),
    c(-2.43118000030518, 1.86417996883392, -0.0949449986219406),
    c(-2.43118000030518, 1.86417996883392, 0.0949449986219406),
    c(-2.41249990463257, 1.84686994552612, 0),
    c(-2.38827991485596, 0.716602027416229, 0),
    c(-2.3822500705719, 0.737662971019745, -0.0958539992570877),
    c(-2.3822500705719, 0.737662971019745, 0.0958539992570877),
    c(-2.37883996963501, 2.05202007293701, -0.0843750014901161),
    c(-2.37883996963501, 2.05202007293701, 0.0843750014901161),
    c(-2.37766003608704, 0.753679990768433, -0.168750002980232),
    c(-2.37766003608704, 0.753679990768433, 0.168750002980232),
    c(-2.36474990844727, 0.798761010169983, -0.199836000800133),
    c(-2.36474990844727, 0.798761010169983, 0.199836000800133),
    c(-2.35430002212524, 0.835254013538361, -0.224999994039536),
    c(-2.35430002212524, 0.835254013538361, 0.224999994039536),
    c(-2.34383988380432, 0.871747016906738, -0.199836000800133),
    c(-2.34383988380432, 0.871747016906738, 0.199836000800133),
    c(-2.3411500453949, 1.99971997737885, -0.196875005960464),
    c(-2.3411500453949, 1.99971997737885, 0.196875005960464),
    c(-2.33092999458313, 0.916827023029327, -0.168750002980232),
    c(-2.33092999458313, 0.916827023029327, 0.168750002980232),
    c(-2.32031011581421, 0.953905999660492, 0),
    c(-2.28931999206543, 1.9278199672699, -0.196875005960464),
    c(-2.28931999206543, 1.9278199672699, 0.196875005960464),
    c(-2.251620054245, 1.87551999092102, -0.0843750014901161),
    c(-2.251620054245, 1.87551999092102, 0.0843750014901161),
    c(-2.24741005897522, 0.882284998893738, -0.0843750014901161),
    c(-2.24741005897522, 0.882284998893738, 0.0843750014901161),
    c(-2.17362999916077, 0.844043016433716, 0),
    c(-2.16852998733521, 0.826951026916504, -0.0971840023994446),
    c(-2.16852998733521, 0.826951026916504, 0.0971840023994446),
    c(-2.16476988792419, 0.814364016056061, -0.168750002980232),
    c(-2.16476988792419, 0.814364016056061, 0.168750002980232),
    c(-2.15687990188599, 0.78669399023056, -0.187068000435829),
    c(-2.15687990188599, 0.78669399023056, 0.187068000435829),
    c(-2.15625, 2.09296989440918, 0),
    c(-2.15411996841431, 0.740520000457764, -0.215193003416061),
    c(-2.15411996841431, 0.740520000457764, 0.215193003416061),
    c(-2.15017008781433, 0.69473397731781, -0.215193003416061),
    c(-2.15017008781433, 0.69473397731781, 0.215193003416061),
    c(-2.14741992950439, 0.648559987545013, -0.187068000435829),
    c(-2.14741992950439, 0.648559987545013, 0.187068000435829),
    c(-2.14495992660522, 0.6127769947052, -0.132947996258736),
    c(-2.14495992660522, 0.6127769947052, 0.132947996258736),
    c(-2.143709897995, 0.59178900718689, -0.0485729984939098),
    c(-2.143709897995, 0.59178900718689, 0.0485729984939098),
    c(-2.14232993125916, 2.05836009979248, -0.168750002980232),
    c(-2.14232993125916, 2.05836009979248, 0.168750002980232),
    c(-2.11172008514404, 1.98222994804382, -0.224999994039536),
    c(-2.11172008514404, 1.98222994804382, 0.224999994039536),
    c(-2.08447003364563, 0.789525985717773, -0.0489050000905991),
    c(-2.08447003364563, 0.789525985717773, 0.0489050000905991),
    c(-2.08109998703003, 1.90609002113342, -0.168750002980232),
    c(-2.08109998703003, 1.90609002113342, 0.168750002980232),
    c(-2.07834005355835, 0.77038699388504, -0.133279994130135),
    c(-2.07834005355835, 0.77038699388504, 0.133279994130135),
    c(-2.06718993186951, 1.87147998809814, 0),
    c(-2, 0.75, 0),
    c(-1.99570000171661, 0.737109005451202, -0.0984380021691322),
    c(-1.99570000171661, 0.737109005451202, 0.0984380021691322),
    c(-1.98438000679016, 0.703125, -0.168750002980232),
    c(-1.98438000679016, 0.703125, 0.168750002980232),
    c(-1.97852003574371, 0.591650009155273, 0),
    c(-1.96937000751495, 0.670825004577637, -0.202656000852585),
    c(-1.96937000751495, 0.670825004577637, 0.202656000852585),
    c(-1.96835994720459, 0.655077993869781, -0.210938006639481),
    c(-1.96835994720459, 0.655077993869781, 0.210938006639481),
    c(-1.96000003814697, 0.75, -0.407499998807907),
    c(-1.96000003814697, 0.75, 0.407499998807907),
    c(-1.9587299823761, 0.925194978713989, -0.201561003923416),
    c(-1.9587299823761, 0.925194978713989, 0.201561003923416),
    c(-1.9570300579071, 1.10038995742798, 0),
    c(-1.95000004768372, 0.600000023841858, -0.224999994039536),
    c(-1.95000004768372, 0.600000023841858, 0.224999994039536),
    c(-1.93894994258881, 0.591650009155273, -0.403122991323471),
    c(-1.93894994258881, 0.591650009155273, 0.403122991323471),
    c(-1.93164002895355, 0.54492199420929, -0.210938006639481),
    c(-1.93164002895355, 0.54492199420929, 0.210938006639481),
    c(-1.93069005012512, 0.5225830078125, -0.198676005005836),
    c(-1.93069005012512, 0.5225830078125, 0.198676005005836),
    c(-1.92188000679016, 0.453516006469727, 0),
    c(-1.91788995265961, 1.10038995742798, -0.398745000362396),
    c(-1.91788995265961, 1.10038995742798, 0.398745000362396),
    c(-1.91561996936798, 0.496874988079071, -0.168750002980232),
    c(-1.91561996936798, 0.496874988079071, 0.168750002980232),
    c(-1.90429997444153, 0.462891012430191, -0.0984380021691322),
    c(-1.90429997444153, 0.462891012430191, 0.0984380021691322),
    c(-1.89999997615814, 0.449999988079071, 0),
    c(-1.89227998256683, 0.670825004577637, -0.593047022819519),
    c(-1.89227998256683, 0.670825004577637, 0.593047022819519),
    c(-1.8834400177002, 0.453516006469727, -0.391582012176514),
    c(-1.8834400177002, 0.453516006469727, 0.391582012176514),
    c(-1.88206005096436, 0.925194978713989, -0.58984500169754),
    c(-1.88206005096436, 0.925194978713989, 0.58984500169754),
    c(-1.88138997554779, 1.28612995147705, -0.193601995706558),
    c(-1.88138997554779, 1.28612995147705, 0.193601995706558),
    c(-1.85511994361877, 0.5225830078125, -0.581402003765106),
    c(-1.85511994361877, 0.5225830078125, 0.581402003765106),
    c(-1.84500002861023, 0.75, -0.785000026226044),
    c(-1.84500002861023, 0.75, 0.785000026226044),
    c(-1.84375, 1.47186994552612, 0),
    c(-1.83317005634308, 1.89067995548248, -0.0843750014901161),
    c(-1.83317005634308, 1.89067995548248, 0.0843750014901161),
    c(-1.83179998397827, 1.94649004936218, -0.196875005960464),
    c(-1.83179998397827, 1.94649004936218, 0.196875005960464),
    c(-1.82992005348206, 2.02323007583618, -0.196875005960464),
    c(-1.82992005348206, 2.02323007583618, 0.196875005960464),
    c(-1.82854998111725, 2.07904005050659, -0.0843750014901161),
    c(-1.82854998111725, 2.07904005050659, 0.0843750014901161),
    c(-1.82518005371094, 0.591650009155273, -0.776566982269287),
    c(-1.82518005371094, 0.591650009155273, 0.776566982269287),
    c(-1.81757998466492, 0.343944996595383, -0.187035992741585),
    c(-1.81757998466492, 0.343944996595383, 0.187035992741585),
    c(-1.80774998664856, 1.28612995147705, -0.566554009914398),
    c(-1.80774998664856, 1.28612995147705, 0.566554009914398),
    c(-1.8068699836731, 1.47186994552612, -0.375663995742798),
    c(-1.8068699836731, 1.47186994552612, 0.375663995742798),
    c(-1.80535995960236, 1.10038995742798, -0.768135011196136),
    c(-1.80535995960236, 1.10038995742798, 0.768135011196136),
    c(-1.77293002605438, 0.453516006469727, -0.754335999488831),
    c(-1.77293002605438, 0.453516006469727, 0.754335999488831),
    c(-1.75, 0.234375, 0),
    c(-1.74644005298615, 0.343944996595383, -0.547339022159576),
    c(-1.74644005298615, 0.343944996595383, 0.547339022159576),
    c(-1.7443300485611, 0.670825004577637, -0.949871003627777),
    c(-1.7443300485611, 0.670825004577637, 0.949871003627777),
    c(-1.7349100112915, 0.925194978713989, -0.944741010665894),
    c(-1.7349100112915, 0.925194978713989, 0.944741010665894),
    c(-1.7150000333786, 0.234375, -0.356563001871109),
    c(-1.7150000333786, 0.234375, 0.356561988592148),
    c(-1.71008002758026, 0.5225830078125, -0.931218028068542),
    c(-1.71008002758026, 0.5225830078125, 0.931218028068542),
    c(-1.70086002349854, 1.47186994552612, -0.723671972751617),
    c(-1.70086002349854, 1.47186994552612, 0.723671972751617),
    c(-1.66639995574951, 1.28612995147705, -0.907437026500702),
    c(-1.66639995574951, 1.28612995147705, 0.907437026500702),
    c(-1.66250002384186, 0.75, -1.125),
    c(-1.66250002384186, 0.75, 1.125),
    c(-1.65515995025635, 1.86093997955322, -0.170322000980377),
    c(-1.65515995025635, 1.86093997955322, 0.170322000980377),
    c(-1.64742004871368, 0.159961000084877, -0.169525995850563),
    c(-1.64742004871368, 0.159961000084877, 0.169525995850563),
    c(-1.64463996887207, 0.591650009155273, -1.11292004585266),
    c(-1.64463996887207, 0.591650009155273, 1.11292004585266),
    c(-1.62678003311157, 1.10038995742798, -1.10082995891571),
    c(-1.62678003311157, 1.10038995742798, 1.10082995891571),
    c(-1.61436998844147, 0.234375, -0.686874985694885),
    c(-1.61436998844147, 0.234375, 0.686874985694885),
    c(-1.60988998413086, 0.343944996595383, -0.876659989356995),
    c(-1.60988998413086, 0.343944996595383, 0.876659989356995),
    c(-1.60000002384186, 1.875, 0),
    c(-1.59756004810333, 0.453516006469727, -1.08106005191803),
    c(-1.59756004810333, 0.453516006469727, 1.08106005191803),
    c(-1.59037005901337, 1.86093997955322, -0.498427987098694),
    c(-1.59037005901337, 1.86093997955322, 0.498427987098694),
    c(-1.58438003063202, 1.91015994548798, -0.168750002980232),
    c(-1.58438003063202, 1.91015994548798, 0.168750002980232),
    c(-1.58293998241425, 0.159961000084877, -0.49609899520874),
    c(-1.58293998241425, 0.159961000084877, 0.49609899520874),
    c(-1.57813000679016, 0.085547000169754, 0),
    c(-1.54999995231628, 1.98749995231628, -0.224999994039536),
    c(-1.54999995231628, 1.98749995231628, 0.224999994039536),
    c(-1.54656004905701, 0.085547000169754, -0.321543008089066),
    c(-1.54656004905701, 0.085547000169754, 0.321543008089066),
    c(-1.53296995162964, 0.670825004577637, -1.26566994190216),
    c(-1.53296995162964, 0.670825004577637, 1.26566994190216),
    c(-1.53261995315552, 1.47186994552612, -1.03710997104645),
    c(-1.53261995315552, 1.47186994552612, 1.03710997104645),
    c(-1.52469003200531, 0.925194978713989, -1.25882995128632),
    c(-1.52469003200531, 0.925194978713989, 1.25882995128632),
    c(-1.52366995811462, 0.042773000895977, -0.156791999936104),
    c(-1.52366995811462, 0.042773000895977, 0.156791999936104),
    c(-1.51563000679016, 2.06484007835388, -0.168750002980232),
    c(-1.51563000679016, 2.06484007835388, 0.168750002980232),
    c(-1.50286996364594, 0.5225830078125, -1.24081003665924),
    c(-1.50286996364594, 0.5225830078125, 1.24081003665924),
    c(-1.5, 0, 0),
    c(-1.5, 2.09999990463257, 0),
    c(-1.5, 2.25, 0),
    c(-1.47000002861023, 0, -0.30562499165535),
    c(-1.47000002861023, 0, 0.30562499165535),
    c(-1.47000002861023, 2.25, -0.30562499165535),
    c(-1.47000002861023, 2.25, 0.30562499165535),
    c(-1.46601998806, 1.86093997955322, -0.79831999540329),
    c(-1.46601998806, 1.86093997955322, 0.79831999540329),
    c(-1.4644900560379, 1.28612995147705, -1.20912003517151),
    c(-1.4644900560379, 1.28612995147705, 1.20912003517151),
    c(-1.46403002738953, 0.042773000895977, -0.458833009004593),
    c(-1.46403002738953, 0.042773000895977, 0.458833009004593),
    c(-1.45985996723175, 2.28691005706787, -0.15022599697113),
    c(-1.45985996723175, 2.28691005706787, 0.15022599697113),
    c(-1.45916998386383, 0.159961000084877, -0.794589996337891),
    c(-1.45916998386383, 0.159961000084877, 0.794589996337891),
    c(-1.45581996440887, 0.085547000169754, -0.61941397190094),
    c(-1.45581996440887, 0.085547000169754, 0.61941397190094),
    c(-1.45468997955322, 0.234375, -0.984375),
    c(-1.45468997955322, 0.234375, 0.984375),
    c(-1.4492199420929, 2.32382988929749, 0),
    c(-1.42023003101349, 2.32382988929749, -0.295278012752533),
    c(-1.42023003101349, 2.32382988929749, 0.295278012752533),
    c(-1.41999995708466, 0.75, -1.41999995708466),
    c(-1.41999995708466, 0.75, 1.41999995708466),
    c(-1.41481995582581, 0.343944996595383, -1.16812002658844),
    c(-1.41481995582581, 0.343944996595383, 1.16812002658844),
    c(-1.41191005706787, 2.33612990379333, -0.14529100060463),
    c(-1.41191005706787, 2.33612990379333, 0.14529100060463),
    c(-1.40474998950958, 0.591650009155273, -1.40474998950958),
    c(-1.40474998950958, 0.591650009155273, 1.40474998950958),
    c(-1.40313005447388, 2.34843993186951, 0),
    c(-1.40271997451782, 2.28691005706787, -0.439617991447449),
    c(-1.40271997451782, 2.28691005706787, 0.439617991447449),
    c(-1.39999997615814, 2.25, 0),
    c(-1.38949000835419, 1.10038995742798, -1.38949000835419),
    c(-1.38949000835419, 1.10038995742798, 1.38949000835419),
    c(-1.38374996185303, 0, -0.588750004768372),
    c(-1.38374996185303, 0, 0.588750004768372),
    c(-1.38374996185303, 2.25, -0.588750004768372),
    c(-1.38374996185303, 2.25, 0.588750004768372),
    c(-1.38047003746033, 2.32382988929749, 0),
    c(-1.37787997722626, 2.33612990379333, -0.141789004206657),
    c(-1.37787997722626, 2.33612990379333, 0.141789004206657),
    c(-1.37633001804352, 2.28691005706787, -0.141629993915558),
    c(-1.37633001804352, 2.28691005706787, 0.141629993915558),
    c(-1.37505996227264, 2.34843993186951, -0.285887002944946),
    c(-1.37505996227264, 2.34843993186951, 0.285887002944946),
    c(-1.37199997901917, 2.25, -0.285250008106232),
    c(-1.37199997901917, 2.25, 0.285250008106232),
    c(-1.36452996730804, 0.453516006469727, -1.36452996730804),
    c(-1.36452996730804, 0.453516006469727, 1.36452996730804),
    c(-1.35664999485016, 2.33612990379333, -0.425177007913589),
    c(-1.35664999485016, 2.33612990379333, 0.425177007913589),
    c(-1.35285997390747, 2.32382988929749, -0.281271010637283),
    c(-1.35285997390747, 2.32382988929749, 0.281271010637283),
    c(-1.34957003593445, 0.042773000895977, -0.734902024269104),
    c(-1.34957003593445, 0.042773000895977, 0.734902024269104),
    c(-1.33689999580383, 2.32382988929749, -0.568817973136902),
    c(-1.33689999580383, 2.32382988929749, 0.568817973136902),
    c(-1.32395005226135, 2.33612990379333, -0.414929002523422),
    c(-1.32395005226135, 2.33612990379333, 0.414929002523422),
    c(-1.32246005535126, 2.28691005706787, -0.414463996887207),
    c(-1.32246005535126, 2.28691005706787, 0.414463996887207),
    c(-1.3118200302124, 0.085547000169754, -0.887695014476776),
    c(-1.3118200302124, 0.085547000169754, 0.887695014476776),
    c(-1.30905997753143, 1.47186994552612, -1.30905997753143),
    c(-1.30905997753143, 1.47186994552612, 1.30905997753143),
    c(-1.29999995231628, 2.25, 0),
    c(-1.2943799495697, 2.34843993186951, -0.550727009773254),
    c(-1.2943799495697, 2.34843993186951, 0.550727009773254),
    c(-1.29305005073547, 2.28691005706787, -0.704126000404358),
    c(-1.29305005073547, 2.28691005706787, 0.704126000404358),
    c(-1.29149997234344, 2.25, -0.549499988555908),
    c(-1.29149997234344, 2.25, 0.549499988555908),
    c(-1.28839004039764, 1.86093997955322, -1.06373000144958),
    c(-1.28839004039764, 1.86093997955322, 1.06373000144958),
    c(-1.28236997127533, 0.159961000084877, -1.05876004695892),
    c(-1.28236997127533, 0.159961000084877, 1.05876004695892),
    c(-1.27400004863739, 2.25, -0.264874994754791),
    c(-1.27400004863739, 2.25, 0.264874994754791),
    c(-1.27348005771637, 2.32382988929749, -0.541833996772766),
    c(-1.27348005771637, 2.32382988929749, 0.541833996772766),
    c(-1.26766002178192, 2.27489995956421, -0.130447998642921),
    c(-1.26766002178192, 2.27489995956421, 0.130447998642921),
    c(-1.26566994190216, 0.670825004577637, -1.53296995162964),
    c(-1.26566994190216, 0.670825004577637, 1.53296995162964),
    c(-1.26093995571136, 2.29979991912842, 0),
    c(-1.25882995128632, 0.925194978713989, -1.52469003200531),
    c(-1.25882995128632, 0.925194978713989, 1.52469003200531),
    c(-1.25057005882263, 2.33612990379333, -0.680997014045715),
    c(-1.25057005882263, 2.33612990379333, 0.680997014045715),
    c(-1.24688005447388, 0, -0.84375),
    c(-1.24688005447388, 0, 0.84375),
    c(-1.24688005447388, 2.25, -0.84375),
    c(-1.24688005447388, 2.25, 0.84375),
    c(-1.24249994754791, 0.234375, -1.24249994754791),
    c(-1.24249994754791, 0.234375, 1.24249994754791),
    c(-1.24081003665924, 0.5225830078125, -1.50286996364594),
    c(-1.24081003665924, 0.5225830078125, 1.50286996364594),
    c(-1.235720038414, 2.29979991912842, -0.256915986537933),
    c(-1.235720038414, 2.29979991912842, 0.256915986537933),
    c(-1.22043001651764, 2.33612990379333, -0.664583027362823),
    c(-1.22043001651764, 2.33612990379333, 0.664583027362823),
    c(-1.21905994415283, 2.28691005706787, -0.663837015628815),
    c(-1.21905994415283, 2.28691005706787, 0.663837015628815),
    c(-1.21805000305176, 2.27489995956421, -0.381740003824234),
    c(-1.21805000305176, 2.27489995956421, 0.381740003824234),
    c(-1.20912003517151, 1.28612995147705, -1.4644900560379),
    c(-1.20912003517151, 1.28612995147705, 1.4644900560379),
    c(-1.20466005802155, 2.32382988929749, -0.815186023712158),
    c(-1.20466005802155, 2.32382988929749, 0.815186023712158),
    c(-1.19924998283386, 2.25, -0.510249972343445),
    c(-1.19924998283386, 2.25, 0.510249972343445),
    c(-1.19650995731354, 2.31943011283875, -0.123125001788139),
    c(-1.19650995731354, 2.31943011283875, 0.123125001788139),
    c(-1.18604004383087, 0.042773000895977, -0.979228973388672),
    c(-1.18604004383087, 0.042773000895977, 0.979228973388672),
    c(-1.16812002658844, 0.343944996595383, -1.41481995582581),
    c(-1.16812002658844, 0.343944996595383, 1.41481995582581),
    c(-1.16635000705719, 2.34843993186951, -0.789258003234863),
    c(-1.16635000705719, 2.34843993186951, 0.789258003234863),
    c(-1.16375005245209, 2.25, -0.787500023841858),
    c(-1.16375005245209, 2.25, 0.787500023841858),
    c(-1.16322004795074, 2.29979991912842, -0.494917988777161),
    c(-1.16322004795074, 2.29979991912842, 0.494917988777161),
    c(-1.15625, 2.33906006813049, 0),
    c(-1.14968001842499, 2.31943011283875, -0.360312014818192),
    c(-1.14968001842499, 2.31943011283875, 0.360312014818192),
    c(-1.14751994609833, 2.32382988929749, -0.776513993740082),
    c(-1.14751994609833, 2.32382988929749, 0.776513993740082),
    c(-1.13636994361877, 2.28691005706787, -0.938220024108887),
    c(-1.13636994361877, 2.28691005706787, 0.938220024108887),
    c(-1.13311994075775, 2.33906006813049, -0.235586002469063),
    c(-1.13311994075775, 2.33906006813049, 0.235586002469063),
    c(-1.125, 0.75, -1.66250002384186),
    c(-1.125, 0.75, 1.66250002384186),
    c(-1.12281000614166, 2.27489995956421, -0.611424028873444),
    c(-1.12281000614166, 2.27489995956421, 0.611424028873444),
    c(-1.12047004699707, 0.085547000169754, -1.12047004699707),
    c(-1.12047004699707, 0.085547000169754, 1.12047004699707),
    c(-1.11292004585266, 0.591650009155273, -1.64463996887207),
    c(-1.11292004585266, 0.591650009155273, 1.64463996887207),
    c(-1.10082995891571, 1.10038995742798, -1.62678003311157),
    c(-1.10082995891571, 1.10038995742798, 1.62678003311157),
    c(-1.09904003143311, 2.33612990379333, -0.907401978969574),
    c(-1.09904003143311, 2.33612990379333, 0.907401978969574),
    c(-1.08106005191803, 0.453516006469727, -1.59756004810333),
    c(-1.08106005191803, 0.453516006469727, 1.59756004810333),
    c(-1.08062994480133, 2.25, -0.731249988079071),
    c(-1.08062994480133, 2.25, 0.731249988079071),
    c(-1.07255005836487, 2.33612990379333, -0.885531008243561),
    c(-1.07255005836487, 2.33612990379333, 0.885531008243561),
    c(-1.07134997844696, 2.28691005706787, -0.884536981582642),
    c(-1.07134997844696, 2.28691005706787, 0.884536981582642),
    c(-1.06664001941681, 2.33906006813049, -0.453828006982803),
    c(-1.06664001941681, 2.33906006813049, 0.453828006982803),
    c(-1.06500005722046, 0, -1.06500005722046),
    c(-1.06500005722046, 0, 1.06500005722046),
    c(-1.06500005722046, 2.25, -1.06500005722046),
    c(-1.06500005722046, 2.25, 1.06500005722046),
    c(-1.06373000144958, 1.86093997955322, -1.28839004039764),
    c(-1.06373000144958, 1.86093997955322, 1.28839004039764),
    c(-1.05979001522064, 2.31943011283875, -0.577103972434998),
    c(-1.05979001522064, 2.31943011283875, 0.577103972434998),
    c(-1.05876004695892, 0.159961000084877, -1.28236997127533),
    c(-1.05876004695892, 0.159961000084877, 1.28236997127533),
    c(-1.04814994335175, 2.29979991912842, -0.709276974201202),
    c(-1.04814994335175, 2.29979991912842, 0.709276974201202),
    c(-1.03710997104645, 1.47186994552612, -1.53261995315552),
    c(-1.03710997104645, 1.47186994552612, 1.53261995315552),
    c(-1.02893996238708, 2.32382988929749, -1.02893996238708),
    c(-1.02893996238708, 2.32382988929749, 1.02893996238708),
    c(-0.996218979358673, 2.34843993186951, -0.996218979358673),
    c(-0.996218979358673, 2.34843993186951, 0.996218979358673),
    c(-0.994000017642975, 2.25, -0.994000017642975),
    c(-0.994000017642975, 2.25, 0.994000017642975),
    c(-0.986760973930359, 2.27489995956421, -0.814697980880737),
    c(-0.986760973930359, 2.27489995956421, 0.814697980880737),
    c(-0.984375, 0.234375, -1.45468997955322),
    c(-0.984375, 0.234375, 1.45468997955322),
    c(-0.980718970298767, 2.36952996253967, -0.100919999182224),
    c(-0.980718970298767, 2.36952996253967, 0.100919999182224),
    c(-0.98013299703598, 2.32382988929749, -0.98013299703598),
    c(-0.98013299703598, 2.32382988929749, 0.98013299703598),
    c(-0.979228973388672, 0.042773000895977, -1.18604004383087),
    c(-0.979228973388672, 0.042773000895977, 1.18604004383087),
    c(-0.961133003234863, 2.33906006813049, -0.650390982627869),
    c(-0.961133003234863, 2.33906006813049, 0.650390982627869),
    c(-0.949871003627777, 0.670825004577637, -1.7443300485611),
    c(-0.949871003627777, 0.670825004577637, 1.7443300485611),
    c(-0.944741010665894, 0.925194978713989, -1.7349100112915),
    c(-0.944741010665894, 0.925194978713989, 1.7349100112915),
    c(-0.942332029342651, 2.36952996253967, -0.295329988002777),
    c(-0.942332029342651, 2.36952996253967, 0.295329988002777),
    c(-0.938220024108887, 2.28691005706787, -1.13636994361877),
    c(-0.938220024108887, 2.28691005706787, 1.13636994361877),
    c(-0.931373000144958, 2.31943011283875, -0.768967986106873),
    c(-0.931373000144958, 2.31943011283875, 0.768967986106873),
    c(-0.931218028068542, 0.5225830078125, -1.71008002758026),
    c(-0.931218028068542, 0.5225830078125, 1.71008002758026),
    c(-0.922999978065491, 2.25, -0.922999978065491),
    c(-0.922999978065491, 2.25, 0.922999978065491),
    c(-0.907437026500702, 1.28612995147705, -1.66639995574951),
    c(-0.907437026500702, 1.28612995147705, 1.66639995574951),
    c(-0.907401978969574, 2.33612990379333, -1.09904003143311),
    c(-0.907401978969574, 2.33612990379333, 1.09904003143311),
    c(-0.895265996456146, 2.29979991912842, -0.895265996456146),
    c(-0.895265996456146, 2.29979991912842, 0.895265996456146),
    c(-0.887695014476776, 0.085547000169754, -1.3118200302124),
    c(-0.887695014476776, 0.085547000169754, 1.3118200302124),
    c(-0.885531008243561, 2.33612990379333, -1.07255005836487),
    c(-0.885531008243561, 2.33612990379333, 1.07255005836487),
    c(-0.884536981582642, 2.28691005706787, -1.07134997844696),
    c(-0.884536981582642, 2.28691005706787, 1.07134997844696),
    c(-0.876659989356995, 0.343944996595383, -1.60988998413086),
    c(-0.876659989356995, 0.343944996595383, 1.60988998413086),
    c(-0.868654012680054, 2.36952996253967, -0.473022997379303),
    c(-0.868654012680054, 2.36952996253967, 0.473022997379303),
    c(-0.84375, 0, -1.24688005447388),
    c(-0.84375, 0, 1.24688005447388),
    c(-0.84375, 2.25, -1.24688005447388),
    c(-0.84375, 2.25, 1.24688005447388),
    c(-0.824999988079071, 2.40000009536743, 0),
    c(-0.820937991142273, 2.33906006813049, -0.820937991142273),
    c(-0.820937991142273, 2.33906006813049, 0.820937991142273),
    c(-0.815186023712158, 2.32382988929749, -1.20466005802155),
    c(-0.815186023712158, 2.32382988929749, 1.20466005802155),
    c(-0.814697980880737, 2.27489995956421, -0.986760973930359),
    c(-0.814697980880737, 2.27489995956421, 0.986760973930359),
    c(-0.808499991893768, 2.40000009536743, -0.168093994259834),
    c(-0.808499991893768, 2.40000009536743, 0.168093994259834),
    c(-0.79831999540329, 1.86093997955322, -1.46601998806),
    c(-0.79831999540329, 1.86093997955322, 1.46601998806),
    c(-0.794589996337891, 0.159961000084877, -1.45916998386383),
    c(-0.794589996337891, 0.159961000084877, 1.45916998386383),
    c(-0.789258003234863, 2.34843993186951, -1.16635000705719),
    c(-0.789258003234863, 2.34843993186951, 1.16635000705719),
    c(-0.787500023841858, 2.25, -1.16375005245209),
    c(-0.787500023841858, 2.25, 1.16375005245209),
    c(-0.785000026226044, 0.75, -1.84500002861023),
    c(-0.785000026226044, 0.75, 1.84500002861023),
    c(-0.776566982269287, 0.591650009155273, -1.82518005371094),
    c(-0.776566982269287, 0.591650009155273, 1.82518005371094),
    c(-0.776513993740082, 2.32382988929749, -1.14751994609833),
    c(-0.776513993740082, 2.32382988929749, 1.14751994609833),
    c(-0.768967986106873, 2.31943011283875, -0.931373000144958),
    c(-0.768967986106873, 2.31943011283875, 0.931373000144958),
    c(-0.768135011196136, 1.10038995742798, -1.80535995960236),
    c(-0.768135011196136, 1.10038995742798, 1.80535995960236),
    c(-0.763400018215179, 2.36952996253967, -0.630285024642944),
    c(-0.763400018215179, 2.36952996253967, 0.630285024642944),
    c(-0.761062979698181, 2.40000009536743, -0.323812991380692),
    c(-0.761062979698181, 2.40000009536743, 0.323812991380692),
    c(-0.754335999488831, 0.453516006469727, -1.77293002605438),
    c(-0.754335999488831, 0.453516006469727, 1.77293002605438),
    c(-0.734902024269104, 0.042773000895977, -1.34957003593445),
    c(-0.734902024269104, 0.042773000895977, 1.34957003593445),
    c(-0.731249988079071, 2.25, -1.08062994480133),
    c(-0.731249988079071, 2.25, 1.08062994480133),
    c(-0.723671972751617, 1.47186994552612, -1.70086002349854),
    c(-0.723671972751617, 1.47186994552612, 1.70086002349854),
    c(-0.709276974201202, 2.29979991912842, -1.04814994335175),
    c(-0.709276974201202, 2.29979991912842, 1.04814994335175),
    c(-0.704126000404358, 2.28691005706787, -1.29305005073547),
    c(-0.704126000404358, 2.28691005706787, 1.29305005073547),
    c(-0.686874985694885, 0.234375, -1.61436998844147),
    c(-0.686874985694885, 0.234375, 1.61436998844147),
    c(-0.685781002044678, 2.40000009536743, -0.464062988758087),
    c(-0.685781002044678, 2.40000009536743, 0.464062988758087),
    c(-0.680997014045715, 2.33612990379333, -1.25057005882263),
    c(-0.680997014045715, 2.33612990379333, 1.25057005882263),
    c(-0.664583027362823, 2.33612990379333, -1.22043001651764),
    c(-0.664583027362823, 2.33612990379333, 1.22043001651764),
    c(-0.663837015628815, 2.28691005706787, -1.21905994415283),
    c(-0.663837015628815, 2.28691005706787, 1.21905994415283),
    c(-0.650390982627869, 2.33906006813049, -0.961133003234863),
    c(-0.650390982627869, 2.33906006813049, 0.961133003234863),
    c(-0.631998002529144, 2.43046998977661, -0.0648249983787537),
    c(-0.631998002529144, 2.43046998977661, 0.0648249983787537),
    c(-0.630285024642944, 2.36952996253967, -0.763400018215179),
    c(-0.630285024642944, 2.36952996253967, 0.763400018215179),
    c(-0.61941397190094, 0.085547000169754, -1.45581996440887),
    c(-0.61941397190094, 0.085547000169754, 1.45581996440887),
    c(-0.611424028873444, 2.27489995956421, -1.12281000614166),
    c(-0.611424028873444, 2.27489995956421, 1.12281000614166),
    c(-0.607173979282379, 2.43046998977661, -0.190548002719879),
    c(-0.607173979282379, 2.43046998977661, 0.190548002719879),
    c(-0.593047022819519, 0.670825004577637, -1.89227998256683),
    c(-0.593047022819519, 0.670825004577637, 1.89227998256683),
    c(-0.58984500169754, 0.925194978713989, -1.88206005096436),
    c(-0.58984500169754, 0.925194978713989, 1.88206005096436),
    c(-0.588750004768372, 0, -1.38374996185303),
    c(-0.588750004768372, 0, 1.38374996185303),
    c(-0.588750004768372, 2.25, -1.38374996185303),
    c(-0.588750004768372, 2.25, 1.38374996185303),
    c(-0.585749983787537, 2.40000009536743, -0.585749983787537),
    c(-0.585749983787537, 2.40000009536743, 0.585749983787537),
    c(-0.581402003765106, 0.5225830078125, -1.85511994361877),
    c(-0.581402003765106, 0.5225830078125, 1.85511994361877),
    c(-0.577103972434998, 2.31943011283875, -1.05979001522064),
    c(-0.577103972434998, 2.31943011283875, 1.05979001522064),
    c(-0.568817973136902, 2.32382988929749, -1.33689999580383),
    c(-0.568817973136902, 2.32382988929749, 1.33689999580383),
    c(-0.566554009914398, 1.28612995147705, -1.80774998664856),
    c(-0.566554009914398, 1.28612995147705, 1.80774998664856),
    c(-0.559973001480103, 2.43046998977661, -0.304711014032364),
    c(-0.559973001480103, 2.43046998977661, 0.304711014032364),
    c(-0.550727009773254, 2.34843993186951, -1.2943799495697),
    c(-0.550727009773254, 2.34843993186951, 1.2943799495697),
    c(-0.549499988555908, 2.25, -1.29149997234344),
    c(-0.549499988555908, 2.25, 1.29149997234344),
    c(-0.547339022159576, 0.343944996595383, -1.74644005298615),
    c(-0.547339022159576, 0.343944996595383, 1.74644005298615),
    c(-0.541833996772766, 2.32382988929749, -1.27348005771637),
    c(-0.541833996772766, 2.32382988929749, 1.27348005771637),
    c(-0.510249972343445, 2.25, -1.19924998283386),
    c(-0.510249972343445, 2.25, 1.19924998283386),
    c(-0.498427987098694, 1.86093997955322, -1.59037005901337),
    c(-0.498427987098694, 1.86093997955322, 1.59037005901337),
    c(-0.49609899520874, 0.159961000084877, -1.58293998241425),
    c(-0.49609899520874, 0.159961000084877, 1.58293998241425),
    c(-0.494917988777161, 2.29979991912842, -1.16322004795074),
    c(-0.494917988777161, 2.29979991912842, 1.16322004795074),
    c(-0.491907000541687, 2.43046998977661, -0.4064100086689),
    c(-0.491907000541687, 2.43046998977661, 0.4064100086689),
    c(-0.473022997379303, 2.36952996253967, -0.868654012680054),
    c(-0.473022997379303, 2.36952996253967, 0.868654012680054),
    c(-0.464062988758087, 2.40000009536743, -0.685781002044678),
    c(-0.464062988758087, 2.40000009536743, 0.685781002044678),
    c(-0.458833009004593, 0.042773000895977, -1.46403002738953),
    c(-0.458833009004593, 0.042773000895977, 1.46403002738953),
    c(-0.456250011920929, 2.46093988418579, 0),
    c(-0.453828006982803, 2.33906006813049, -1.06664001941681),
    c(-0.453828006982803, 2.33906006813049, 1.06664001941681),
    c(-0.439617991447449, 2.28691005706787, -1.40271997451782),
    c(-0.439617991447449, 2.28691005706787, 1.40271997451782),
    c(-0.438241004943848, 2.46093988418579, -0.0912069976329803),
    c(-0.438241004943848, 2.46093988418579, 0.0912069976329803),
    c(-0.425177007913589, 2.33612990379333, -1.35664999485016),
    c(-0.425177007913589, 2.33612990379333, 1.35664999485016),
    c(-0.420890986919403, 2.46093988418579, -0.179077997803688),
    c(-0.420890986919403, 2.46093988418579, 0.179077997803688),
    c(-0.414929002523422, 2.33612990379333, -1.32395005226135),
    c(-0.414929002523422, 2.33612990379333, 1.32395005226135),
    c(-0.414463996887207, 2.28691005706787, -1.32246005535126),
    c(-0.414463996887207, 2.28691005706787, 1.32246005535126),
    c(-0.407499998807907, 0.75, -1.96000003814697),
    c(-0.407499998807907, 0.75, 1.96000003814697),
    c(-0.4064100086689, 2.43046998977661, -0.491907000541687),
    c(-0.4064100086689, 2.43046998977661, 0.491907000541687),
    c(-0.403122991323471, 0.591650009155273, -1.93894994258881),
    c(-0.403122991323471, 0.591650009155273, 1.93894994258881),
    c(-0.398745000362396, 1.10038995742798, -1.91788995265961),
    c(-0.398745000362396, 1.10038995742798, 1.91788995265961),
    c(-0.391582012176514, 0.453516006469727, -1.8834400177002),
    c(-0.391582012176514, 0.453516006469727, 1.8834400177002),
    c(-0.381740003824234, 2.27489995956421, -1.21805000305176),
    c(-0.381740003824234, 2.27489995956421, 1.21805000305176),
    c(-0.375663995742798, 1.47186994552612, -1.8068699836731),
    c(-0.375663995742798, 1.47186994552612, 1.8068699836731),
    c(-0.372159004211426, 2.46093988418579, -0.251888990402222),
    c(-0.372159004211426, 2.46093988418579, 0.251888990402222),
    c(-0.362109005451202, 2.8971700668335, 0),
    c(-0.360312014818192, 2.31943011283875, -1.14968001842499),
    c(-0.360312014818192, 2.31943011283875, 1.14968001842499),
    c(-0.356563001871109, 0.234375, 1.7150000333786),
    c(-0.356561988592148, 0.234375, -1.7150000333786),
    c(-0.340624988079071, 2.95077991485596, 0),
    c(-0.337859004735947, 2.92396998405457, -0.0692780017852783),
    c(-0.337859004735947, 2.92396998405457, 0.0692780017852783),
    c(-0.334237992763519, 2.8971700668335, -0.142704993486404),
    c(-0.334237992763519, 2.8971700668335, 0.142704993486404),
    c(-0.33032500743866, 2.8642098903656, -0.067671999335289),
    c(-0.33032500743866, 2.8642098903656, 0.067671999335289),
    c(-0.324999988079071, 2.83124995231628, 0),
    c(-0.323938012123108, 2.46093988418579, -0.323938012123108),
    c(-0.323938012123108, 2.46093988418579, 0.323938012123108),
    c(-0.323812991380692, 2.40000009536743, -0.761062979698181),
    c(-0.323812991380692, 2.40000009536743, 0.761062979698181),
    c(-0.321543008089066, 0.085547000169754, -1.54656004905701),
    c(-0.321543008089066, 0.085547000169754, 1.54656004905701),
    c(-0.315409988164902, 2.50547003746033, -0.0643950030207634),
    c(-0.315409988164902, 2.50547003746033, 0.0643950030207634),
    c(-0.314464002847672, 2.95077991485596, -0.134406998753548),
    c(-0.314464002847672, 2.95077991485596, 0.134406998753548),
    c(-0.30562499165535, 0, -1.47000002861023),
    c(-0.30562499165535, 0, 1.47000002861023),
    c(-0.30562499165535, 2.25, -1.47000002861023),
    c(-0.30562499165535, 2.25, 1.47000002861023),
    c(-0.304711014032364, 2.43046998977661, -0.559973001480103),
    c(-0.304711014032364, 2.43046998977661, 0.559973001480103),
    c(-0.299953013658524, 2.83124995231628, -0.127984002232552),
    c(-0.299953013658524, 2.83124995231628, 0.127984002232552),
    c(-0.295329988002777, 2.36952996253967, -0.942332029342651),
    c(-0.295329988002777, 2.36952996253967, 0.942332029342651),
    c(-0.295278012752533, 2.32382988929749, -1.42023003101349),
    c(-0.295278012752533, 2.32382988929749, 1.42023003101349),
    c(-0.28719699382782, 2.92396998405457, -0.1942999958992),
    c(-0.28719699382782, 2.92396998405457, 0.1942999958992),
    c(-0.285887002944946, 2.34843993186951, -1.37505996227264),
    c(-0.285887002944946, 2.34843993186951, 1.37505996227264),
    c(-0.285250008106232, 2.25, -1.37199997901917),
    c(-0.285250008106232, 2.25, 1.37199997901917),
    c(-0.281271010637283, 2.32382988929749, -1.35285997390747),
    c(-0.281271010637283, 2.32382988929749, 1.35285997390747),
    c(-0.280732005834579, 2.8642098903656, -0.189855992794037),
    c(-0.280732005834579, 2.8642098903656, 0.189855992794037),
    c(-0.274421006441116, 2.96880006790161, -0.0563799999654293),
    c(-0.274421006441116, 2.96880006790161, 0.0563799999654293),
    c(-0.267832010984421, 2.50547003746033, -0.18087899684906),
    c(-0.267832010984421, 2.50547003746033, 0.18087899684906),
    c(-0.264874994754791, 2.25, -1.27400004863739),
    c(-0.264874994754791, 2.25, 1.27400004863739),
    c(-0.257609993219376, 2.8971700668335, -0.257609993219376),
    c(-0.257609993219376, 2.8971700668335, 0.257609993219376),
    c(-0.256915986537933, 2.29979991912842, -1.235720038414),
    c(-0.256915986537933, 2.29979991912842, 1.235720038414),
    c(-0.251888990402222, 2.46093988418579, -0.372159004211426),
    c(-0.251888990402222, 2.46093988418579, 0.372159004211426),
    c(-0.250871986150742, 2.7574200630188, -0.0513469986617565),
    c(-0.250871986150742, 2.7574200630188, 0.0513469986617565),
    c(-0.242476999759674, 2.95077991485596, -0.242476999759674),
    c(-0.242476999759674, 2.95077991485596, 0.242476999759674),
    c(-0.235586002469063, 2.33906006813049, -1.13311994075775),
    c(-0.235586002469063, 2.33906006813049, 1.13311994075775),
    c(-0.233382001519203, 2.96880006790161, -0.158017992973328),
    c(-0.233382001519203, 2.96880006790161, 0.158017992973328),
    c(-0.231124997138977, 2.83124995231628, -0.231124997138977),
    c(-0.231124997138977, 2.83124995231628, 0.231124997138977),
    c(-0.230077996850014, 2.98681998252869, 0),
    c(-0.213158994913101, 2.7574200630188, -0.14410300552845),
    c(-0.213158994913101, 2.7574200630188, 0.14410300552845),
    c(-0.212515994906425, 2.98681998252869, -0.0911130011081696),
    c(-0.212515994906425, 2.98681998252869, 0.0911130011081696),
    c(-0.202656000852585, 0.670825004577637, -1.96937000751495),
    c(-0.202656000852585, 0.670825004577637, 1.96937000751495),
    c(-0.201561003923416, 0.925194978713989, -1.9587299823761),
    c(-0.201561003923416, 0.925194978713989, 1.9587299823761),
    c(-0.200000002980232, 2.54999995231628, 0),
    c(-0.198676005005836, 0.5225830078125, -1.93069005012512),
    c(-0.198676005005836, 0.5225830078125, 1.93069005012512),
    c(-0.196875005960464, 2.68358993530273, 0),
    c(-0.1942999958992, 2.92396998405457, -0.28719699382782),
    c(-0.1942999958992, 2.92396998405457, 0.28719699382782),
    c(-0.193601995706558, 1.28612995147705, -1.88138997554779),
    c(-0.193601995706558, 1.28612995147705, 1.88138997554779),
    c(-0.190548002719879, 2.43046998977661, -0.607173979282379),
    c(-0.190548002719879, 2.43046998977661, 0.607173979282379),
    c(-0.189855992794037, 2.8642098903656, -0.280732005834579),
    c(-0.189855992794037, 2.8642098903656, 0.280732005834579),
    c(-0.187035992741585, 0.343944996595383, -1.81757998466492),
    c(-0.187035992741585, 0.343944996595383, 1.81757998466492),
    c(-0.184499993920326, 2.54999995231628, -0.0785000026226044),
    c(-0.184499993920326, 2.54999995231628, 0.0785000026226044),
    c(-0.181660994887352, 2.68358993530273, -0.0774049982428551),
    c(-0.181660994887352, 2.68358993530273, 0.0774049982428551),
    c(-0.18087899684906, 2.50547003746033, -0.267832010984421),
    c(-0.18087899684906, 2.50547003746033, 0.267832010984421),
    c(-0.179077997803688, 2.46093988418579, -0.420890986919403),
    c(-0.179077997803688, 2.46093988418579, 0.420890986919403),
    c(-0.17629499733448, 2.58119988441467, -0.0360010005533695),
    c(-0.17629499733448, 2.58119988441467, 0.0360010005533695),
    c(-0.174804002046585, 2.64800000190735, -0.0357270017266273),
    c(-0.174804002046585, 2.64800000190735, 0.0357270017266273),
    c(-0.170322000980377, 1.86093997955322, -1.65515995025635),
    c(-0.170322000980377, 1.86093997955322, 1.65515995025635),
    c(-0.169525995850563, 0.159961000084877, -1.64742004871368),
    c(-0.169525995850563, 0.159961000084877, 1.64742004871368),
    c(-0.168093994259834, 2.40000009536743, -0.808499991893768),
    c(-0.168093994259834, 2.40000009536743, 0.808499991893768),
    c(-0.166796997189522, 2.61240005493164, 0),
    c(-0.164073005318642, 2.98681998252869, -0.164073005318642),
    c(-0.164073005318642, 2.98681998252869, 0.164073005318642),
    c(-0.158017992973328, 2.96880006790161, -0.233382001519203),
    c(-0.158017992973328, 2.96880006790161, 0.233382001519203),
    c(-0.156791999936104, 0.042773000895977, -1.52366995811462),
    c(-0.156791999936104, 0.042773000895977, 1.52366995811462),
    c(-0.153881996870041, 2.61240005493164, -0.0655039995908737),
    c(-0.153881996870041, 2.61240005493164, 0.0655039995908737),
    c(-0.15022599697113, 2.28691005706787, -1.45985996723175),
    c(-0.15022599697113, 2.28691005706787, 1.45985996723175),
    c(-0.14970999956131, 2.58119988441467, -0.101116001605988),
    c(-0.14970999956131, 2.58119988441467, 0.101116001605988),
    c(-0.148475006222725, 2.64800000190735, -0.100316002964973),
    c(-0.148475006222725, 2.64800000190735, 0.100316002964973),
    c(-0.14529100060463, 2.33612990379333, -1.41191005706787),
    c(-0.14529100060463, 2.33612990379333, 1.41191005706787),
    c(-0.14410300552845, 2.7574200630188, -0.213158994913101),
    c(-0.14410300552845, 2.7574200630188, 0.213158994913101),
    c(-0.142704993486404, 2.8971700668335, -0.334237992763519),
    c(-0.142704993486404, 2.8971700668335, 0.334237992763519),
    c(-0.142000004649162, 2.54999995231628, -0.142000004649162),
    c(-0.142000004649162, 2.54999995231628, 0.142000004649162),
    c(-0.141789004206657, 2.33612990379333, -1.37787997722626),
    c(-0.141789004206657, 2.33612990379333, 1.37787997722626),
    c(-0.141629993915558, 2.28691005706787, -1.37633001804352),
    c(-0.141629993915558, 2.28691005706787, 1.37633001804352),
    c(-0.139898002147675, 2.68358993530273, -0.139898002147675),
    c(-0.139898002147675, 2.68358993530273, 0.139898002147675),
    c(-0.134406998753548, 2.95077991485596, -0.314464002847672),
    c(-0.134406998753548, 2.95077991485596, 0.314464002847672),
    c(-0.130447998642921, 2.27489995956421, -1.26766002178192),
    c(-0.130447998642921, 2.27489995956421, 1.26766002178192),
    c(-0.127984002232552, 2.83124995231628, -0.299953013658524),
    c(-0.127984002232552, 2.83124995231628, 0.299953013658524),
    c(-0.123125001788139, 2.31943011283875, -1.19650995731354),
    c(-0.123125001788139, 2.31943011283875, 1.19650995731354),
    c(-0.11845800280571, 2.61240005493164, -0.11845800280571),
    c(-0.11845800280571, 2.61240005493164, 0.11845800280571),
    c(-0.11064899712801, 2.99341011047363, -0.0227780006825924),
    c(-0.11064899712801, 2.99341011047363, 0.0227780006825924),
    c(-0.101116001605988, 2.58119988441467, -0.14970999956131),
    c(-0.101116001605988, 2.58119988441467, 0.14970999956131),
    c(-0.100919999182224, 2.36952996253967, -0.980718970298767),
    c(-0.100919999182224, 2.36952996253967, 0.980718970298767),
    c(-0.100316002964973, 2.64800000190735, -0.148475006222725),
    c(-0.100316002964973, 2.64800000190735, 0.148475006222725),
    c(-0.0941469967365265, 2.99341011047363, -0.0637969970703125),
    c(-0.0941469967365265, 2.99341011047363, 0.0637969970703125),
    c(-0.0912069976329803, 2.46093988418579, -0.438241004943848),
    c(-0.0912069976329803, 2.46093988418579, 0.438241004943848),
    c(-0.0911130011081696, 2.98681998252869, -0.212515994906425),
    c(-0.0911130011081696, 2.98681998252869, 0.212515994906425),
    c(-0.0785000026226044, 2.54999995231628, -0.184499993920326),
    c(-0.0785000026226044, 2.54999995231628, 0.184499993920326),
    c(-0.0774049982428551, 2.68358993530273, -0.181660994887352),
    c(-0.0774049982428551, 2.68358993530273, 0.181660994887352),
    c(-0.0692780017852783, 2.92396998405457, -0.337859004735947),
    c(-0.0692780017852783, 2.92396998405457, 0.337859004735947),
    c(-0.067671999335289, 2.8642098903656, -0.33032500743866),
    c(-0.067671999335289, 2.8642098903656, 0.33032500743866),
    c(-0.0655039995908737, 2.61240005493164, -0.153881996870041),
    c(-0.0655039995908737, 2.61240005493164, 0.153881996870041),
    c(-0.0648249983787537, 2.43046998977661, -0.631998002529144),
    c(-0.0648249983787537, 2.43046998977661, 0.631998002529144),
    c(-0.0643950030207634, 2.50547003746033, -0.315409988164902),
    c(-0.0643950030207634, 2.50547003746033, 0.315409988164902),
    c(-0.0637969970703125, 2.99341011047363, -0.0941469967365265),
    c(-0.0637969970703125, 2.99341011047363, 0.0941469967365265),
    c(-0.0563799999654293, 2.96880006790161, -0.274421006441116),
    c(-0.0563799999654293, 2.96880006790161, 0.274421006441116),
    c(-0.0513469986617565, 2.7574200630188, -0.250871986150742),
    c(-0.0513469986617565, 2.7574200630188, 0.250871986150742),
    c(-0.0360010005533695, 2.58119988441467, -0.17629499733448),
    c(-0.0360010005533695, 2.58119988441467, 0.17629499733448),
    c(-0.0357270017266273, 2.64800000190735, -0.174804002046585),
    c(-0.0357270017266273, 2.64800000190735, 0.174804002046585),
    c(-0.0227780006825924, 2.99341011047363, -0.11064899712801),
    c(-0.0227780006825924, 2.99341011047363, 0.11064899712801),
    c(0, 0, -1.5),
    c(0, 0, 1.5),
    c(0, 0.085547000169754, -1.57813000679016),
    c(0, 0.085547000169754, 1.57813000679016),
    c(0, 0.234375, -1.75),
    c(0, 0.234375, 1.75),
    c(0, 0.453516006469727, -1.92188000679016),
    c(0, 0.453516006469727, 1.92188000679016),
    c(0, 0.591650009155273, -1.97852003574371),
    c(0, 0.591650009155273, 1.97852003574371),
    c(0, 0.75, -2),
    c(0, 0.75, 2),
    c(0, 1.10038995742798, -1.9570300579071),
    c(0, 1.10038995742798, 1.9570300579071),
    c(0, 1.47186994552612, -1.84375),
    c(0, 1.47186994552612, 1.84375),
    c(0, 2.25, -1.5),
    c(0, 2.25, -1.39999997615814),
    c(0, 2.25, -1.29999995231628),
    c(0, 2.25, 1.29999995231628),
    c(0, 2.25, 1.39999997615814),
    c(0, 2.25, 1.5),
    c(0, 2.29979991912842, -1.26093995571136),
    c(0, 2.29979991912842, 1.26093995571136),
    c(0, 2.32382988929749, -1.4492199420929),
    c(0, 2.32382988929749, -1.38047003746033),
    c(0, 2.32382988929749, 1.38047003746033),
    c(0, 2.32382988929749, 1.4492199420929),
    c(0, 2.33906006813049, -1.15625),
    c(0, 2.33906006813049, 1.15625),
    c(0, 2.34843993186951, -1.40313005447388),
    c(0, 2.34843993186951, 1.40313005447388),
    c(0, 2.40000009536743, -0.824999988079071),
    c(0, 2.40000009536743, 0.824999988079071),
    c(0, 2.46093988418579, -0.456250011920929),
    c(0, 2.46093988418579, 0.456250011920929),
    c(0, 2.54999995231628, -0.200000002980232),
    c(0, 2.54999995231628, 0.200000002980232),
    c(0, 2.61240005493164, -0.166796997189522),
    c(0, 2.61240005493164, 0.166796997189522),
    c(0, 2.68358993530273, -0.196875005960464),
    c(0, 2.68358993530273, 0.196875005960464),
    c(0, 2.83124995231628, -0.324999988079071),
    c(0, 2.83124995231628, 0.324999988079071),
    c(0, 2.8971700668335, -0.362109005451202),
    c(0, 2.8971700668335, 0.362109005451202),
    c(0, 2.95077991485596, -0.340624988079071),
    c(0, 2.95077991485596, 0.340624988079071),
    c(0, 2.98681998252869, -0.230077996850014),
    c(0, 2.98681998252869, 0.230077996850014),
    c(0, 3, 0),
    c(0.0227780006825924, 2.99341011047363, -0.11064899712801),
    c(0.0227780006825924, 2.99341011047363, 0.11064899712801),
    c(0.0357270017266273, 2.64800000190735, -0.174804002046585),
    c(0.0357270017266273, 2.64800000190735, 0.174804002046585),
    c(0.0360010005533695, 2.58119988441467, -0.17629499733448),
    c(0.0360010005533695, 2.58119988441467, 0.17629499733448),
    c(0.0513469986617565, 2.7574200630188, -0.250871986150742),
    c(0.0513469986617565, 2.7574200630188, 0.250871986150742),
    c(0.0563799999654293, 2.96880006790161, -0.274421006441116),
    c(0.0563799999654293, 2.96880006790161, 0.274421006441116),
    c(0.0637969970703125, 2.99341011047363, -0.0941469967365265),
    c(0.0637969970703125, 2.99341011047363, 0.0941469967365265),
    c(0.0643950030207634, 2.50547003746033, -0.315409988164902),
    c(0.0643950030207634, 2.50547003746033, 0.315409988164902),
    c(0.0648249983787537, 2.43046998977661, -0.631998002529144),
    c(0.0648249983787537, 2.43046998977661, 0.631998002529144),
    c(0.0655039995908737, 2.61240005493164, -0.153881996870041),
    c(0.0655039995908737, 2.61240005493164, 0.153881996870041),
    c(0.067671999335289, 2.8642098903656, -0.33032500743866),
    c(0.067671999335289, 2.8642098903656, 0.33032500743866),
    c(0.0692780017852783, 2.92396998405457, -0.337859004735947),
    c(0.0692780017852783, 2.92396998405457, 0.337859004735947),
    c(0.0774049982428551, 2.68358993530273, -0.181660994887352),
    c(0.0774049982428551, 2.68358993530273, 0.181660994887352),
    c(0.0785000026226044, 2.54999995231628, -0.184499993920326),
    c(0.0785000026226044, 2.54999995231628, 0.184499993920326),
    c(0.0911130011081696, 2.98681998252869, -0.212515994906425),
    c(0.0911130011081696, 2.98681998252869, 0.212515994906425),
    c(0.0912069976329803, 2.46093988418579, -0.438241004943848),
    c(0.0912069976329803, 2.46093988418579, 0.438241004943848),
    c(0.0941469967365265, 2.99341011047363, -0.0637969970703125),
    c(0.0941469967365265, 2.99341011047363, 0.0637969970703125),
    c(0.100316002964973, 2.64800000190735, -0.148475006222725),
    c(0.100316002964973, 2.64800000190735, 0.148475006222725),
    c(0.100919999182224, 2.36952996253967, -0.980718970298767),
    c(0.100919999182224, 2.36952996253967, 0.980718970298767),
    c(0.101116001605988, 2.58119988441467, -0.14970999956131),
    c(0.101116001605988, 2.58119988441467, 0.14970999956131),
    c(0.11064899712801, 2.99341011047363, -0.0227780006825924),
    c(0.11064899712801, 2.99341011047363, 0.0227780006825924),
    c(0.11845800280571, 2.61240005493164, -0.11845800280571),
    c(0.11845800280571, 2.61240005493164, 0.11845800280571),
    c(0.123125001788139, 2.31943011283875, -1.19650995731354),
    c(0.123125001788139, 2.31943011283875, 1.19650995731354),
    c(0.127984002232552, 2.83124995231628, -0.299953013658524),
    c(0.127984002232552, 2.83124995231628, 0.299953013658524),
    c(0.130447998642921, 2.27489995956421, -1.26766002178192),
    c(0.130447998642921, 2.27489995956421, 1.26766002178192),
    c(0.134406998753548, 2.95077991485596, -0.314464002847672),
    c(0.134406998753548, 2.95077991485596, 0.314464002847672),
    c(0.139898002147675, 2.68358993530273, -0.139898002147675),
    c(0.139898002147675, 2.68358993530273, 0.139898002147675),
    c(0.141629993915558, 2.28691005706787, -1.37633001804352),
    c(0.141629993915558, 2.28691005706787, 1.37633001804352),
    c(0.141789004206657, 2.33612990379333, -1.37787997722626),
    c(0.141789004206657, 2.33612990379333, 1.37787997722626),
    c(0.142000004649162, 2.54999995231628, -0.142000004649162),
    c(0.142000004649162, 2.54999995231628, 0.142000004649162),
    c(0.142704993486404, 2.8971700668335, -0.334237992763519),
    c(0.142704993486404, 2.8971700668335, 0.334237992763519),
    c(0.14410300552845, 2.7574200630188, -0.213158994913101),
    c(0.14410300552845, 2.7574200630188, 0.213158994913101),
    c(0.14529100060463, 2.33612990379333, -1.41191005706787),
    c(0.14529100060463, 2.33612990379333, 1.41191005706787),
    c(0.148475006222725, 2.64800000190735, -0.100316002964973),
    c(0.148475006222725, 2.64800000190735, 0.100316002964973),
    c(0.14970999956131, 2.58119988441467, -0.101116001605988),
    c(0.14970999956131, 2.58119988441467, 0.101116001605988),
    c(0.15022599697113, 2.28691005706787, -1.45985996723175),
    c(0.15022599697113, 2.28691005706787, 1.45985996723175),
    c(0.153881996870041, 2.61240005493164, -0.0655039995908737),
    c(0.153881996870041, 2.61240005493164, 0.0655039995908737),
    c(0.156791999936104, 0.042773000895977, -1.52366995811462),
    c(0.156791999936104, 0.042773000895977, 1.52366995811462),
    c(0.158017992973328, 2.96880006790161, -0.233382001519203),
    c(0.158017992973328, 2.96880006790161, 0.233382001519203),
    c(0.164073005318642, 2.98681998252869, -0.164073005318642),
    c(0.164073005318642, 2.98681998252869, 0.164073005318642),
    c(0.166796997189522, 2.61240005493164, 0),
    c(0.168093994259834, 2.40000009536743, -0.808499991893768),
    c(0.168093994259834, 2.40000009536743, 0.808499991893768),
    c(0.169525995850563, 0.159961000084877, -1.64742004871368),
    c(0.169525995850563, 0.159961000084877, 1.64742004871368),
    c(0.170322000980377, 1.86093997955322, -1.65515995025635),
    c(0.170322000980377, 1.86093997955322, 1.65515995025635),
    c(0.174804002046585, 2.64800000190735, -0.0357270017266273),
    c(0.174804002046585, 2.64800000190735, 0.0357270017266273),
    c(0.17629499733448, 2.58119988441467, -0.0360010005533695),
    c(0.17629499733448, 2.58119988441467, 0.0360010005533695),
    c(0.179077997803688, 2.46093988418579, -0.420890986919403),
    c(0.179077997803688, 2.46093988418579, 0.420890986919403),
    c(0.18087899684906, 2.50547003746033, -0.267832010984421),
    c(0.18087899684906, 2.50547003746033, 0.267832010984421),
    c(0.181660994887352, 2.68358993530273, -0.0774049982428551),
    c(0.181660994887352, 2.68358993530273, 0.0774049982428551),
    c(0.184499993920326, 2.54999995231628, -0.0785000026226044),
    c(0.184499993920326, 2.54999995231628, 0.0785000026226044),
    c(0.187035992741585, 0.343944996595383, -1.81757998466492),
    c(0.187035992741585, 0.343944996595383, 1.81757998466492),
    c(0.189855992794037, 2.8642098903656, -0.280732005834579),
    c(0.189855992794037, 2.8642098903656, 0.280732005834579),
    c(0.190548002719879, 2.43046998977661, -0.607173979282379),
    c(0.190548002719879, 2.43046998977661, 0.607173979282379),
    c(0.193601995706558, 1.28612995147705, -1.88138997554779),
    c(0.193601995706558, 1.28612995147705, 1.88138997554779),
    c(0.1942999958992, 2.92396998405457, -0.28719699382782),
    c(0.1942999958992, 2.92396998405457, 0.28719699382782),
    c(0.196875005960464, 2.68358993530273, 0),
    c(0.198676005005836, 0.5225830078125, -1.93069005012512),
    c(0.198676005005836, 0.5225830078125, 1.93069005012512),
    c(0.200000002980232, 2.54999995231628, 0),
    c(0.201561003923416, 0.925194978713989, -1.9587299823761),
    c(0.201561003923416, 0.925194978713989, 1.9587299823761),
    c(0.202656000852585, 0.670825004577637, -1.96937000751495),
    c(0.202656000852585, 0.670825004577637, 1.96937000751495),
    c(0.212515994906425, 2.98681998252869, -0.0911130011081696),
    c(0.212515994906425, 2.98681998252869, 0.0911130011081696),
    c(0.213158994913101, 2.7574200630188, -0.14410300552845),
    c(0.213158994913101, 2.7574200630188, 0.14410300552845),
    c(0.230077996850014, 2.98681998252869, 0),
    c(0.231124997138977, 2.83124995231628, -0.231124997138977),
    c(0.231124997138977, 2.83124995231628, 0.231124997138977),
    c(0.233382001519203, 2.96880006790161, -0.158017992973328),
    c(0.233382001519203, 2.96880006790161, 0.158017992973328),
    c(0.235586002469063, 2.33906006813049, -1.13311994075775),
    c(0.235586002469063, 2.33906006813049, 1.13311994075775),
    c(0.242476999759674, 2.95077991485596, -0.242476999759674),
    c(0.242476999759674, 2.95077991485596, 0.242476999759674),
    c(0.250871986150742, 2.7574200630188, -0.0513469986617565),
    c(0.250871986150742, 2.7574200630188, 0.0513469986617565),
    c(0.251888990402222, 2.46093988418579, -0.372159004211426),
    c(0.251888990402222, 2.46093988418579, 0.372159004211426),
    c(0.256915986537933, 2.29979991912842, -1.235720038414),
    c(0.256915986537933, 2.29979991912842, 1.235720038414),
    c(0.257609993219376, 2.8971700668335, -0.257609993219376),
    c(0.257609993219376, 2.8971700668335, 0.257609993219376),
    c(0.264874994754791, 2.25, -1.27400004863739),
    c(0.264874994754791, 2.25, 1.27400004863739),
    c(0.267832010984421, 2.50547003746033, -0.18087899684906),
    c(0.267832010984421, 2.50547003746033, 0.18087899684906),
    c(0.274421006441116, 2.96880006790161, -0.0563799999654293),
    c(0.274421006441116, 2.96880006790161, 0.0563799999654293),
    c(0.280732005834579, 2.8642098903656, -0.189855992794037),
    c(0.280732005834579, 2.8642098903656, 0.189855992794037),
    c(0.281271010637283, 2.32382988929749, -1.35285997390747),
    c(0.281271010637283, 2.32382988929749, 1.35285997390747),
    c(0.285250008106232, 2.25, -1.37199997901917),
    c(0.285250008106232, 2.25, 1.37199997901917),
    c(0.285887002944946, 2.34843993186951, -1.37505996227264),
    c(0.285887002944946, 2.34843993186951, 1.37505996227264),
    c(0.28719699382782, 2.92396998405457, -0.1942999958992),
    c(0.28719699382782, 2.92396998405457, 0.1942999958992),
    c(0.295278012752533, 2.32382988929749, -1.42023003101349),
    c(0.295278012752533, 2.32382988929749, 1.42023003101349),
    c(0.295329988002777, 2.36952996253967, -0.942332029342651),
    c(0.295329988002777, 2.36952996253967, 0.942332029342651),
    c(0.299953013658524, 2.83124995231628, -0.127984002232552),
    c(0.299953013658524, 2.83124995231628, 0.127984002232552),
    c(0.304711014032364, 2.43046998977661, -0.559973001480103),
    c(0.304711014032364, 2.43046998977661, 0.559973001480103),
    c(0.30562499165535, 0, -1.47000002861023),
    c(0.30562499165535, 0, 1.47000002861023),
    c(0.30562499165535, 2.25, -1.47000002861023),
    c(0.30562499165535, 2.25, 1.47000002861023),
    c(0.314464002847672, 2.95077991485596, -0.134406998753548),
    c(0.314464002847672, 2.95077991485596, 0.134406998753548),
    c(0.315409988164902, 2.50547003746033, -0.0643950030207634),
    c(0.315409988164902, 2.50547003746033, 0.0643950030207634),
    c(0.321543008089066, 0.085547000169754, -1.54656004905701),
    c(0.321543008089066, 0.085547000169754, 1.54656004905701),
    c(0.323812991380692, 2.40000009536743, -0.761062979698181),
    c(0.323812991380692, 2.40000009536743, 0.761062979698181),
    c(0.323938012123108, 2.46093988418579, -0.323938012123108),
    c(0.323938012123108, 2.46093988418579, 0.323938012123108),
    c(0.324999988079071, 2.83124995231628, 0),
    c(0.33032500743866, 2.8642098903656, -0.067671999335289),
    c(0.33032500743866, 2.8642098903656, 0.067671999335289),
    c(0.334237992763519, 2.8971700668335, -0.142704993486404),
    c(0.334237992763519, 2.8971700668335, 0.142704993486404),
    c(0.337859004735947, 2.92396998405457, -0.0692780017852783),
    c(0.337859004735947, 2.92396998405457, 0.0692780017852783),
    c(0.340624988079071, 2.95077991485596, 0),
    c(0.356561988592148, 0.234375, 1.7150000333786),
    c(0.356563001871109, 0.234375, -1.7150000333786),
    c(0.360312014818192, 2.31943011283875, -1.14968001842499),
    c(0.360312014818192, 2.31943011283875, 1.14968001842499),
    c(0.362109005451202, 2.8971700668335, 0),
    c(0.372159004211426, 2.46093988418579, -0.251888990402222),
    c(0.372159004211426, 2.46093988418579, 0.251888990402222),
    c(0.375663995742798, 1.47186994552612, -1.8068699836731),
    c(0.375663995742798, 1.47186994552612, 1.8068699836731),
    c(0.381740003824234, 2.27489995956421, -1.21805000305176),
    c(0.381740003824234, 2.27489995956421, 1.21805000305176),
    c(0.391582012176514, 0.453516006469727, -1.8834400177002),
    c(0.391582012176514, 0.453516006469727, 1.8834400177002),
    c(0.398745000362396, 1.10038995742798, -1.91788995265961),
    c(0.398745000362396, 1.10038995742798, 1.91788995265961),
    c(0.403122991323471, 0.591650009155273, -1.93894994258881),
    c(0.403122991323471, 0.591650009155273, 1.93894994258881),
    c(0.4064100086689, 2.43046998977661, -0.491907000541687),
    c(0.4064100086689, 2.43046998977661, 0.491907000541687),
    c(0.407499998807907, 0.75, -1.96000003814697),
    c(0.407499998807907, 0.75, 1.96000003814697),
    c(0.414463996887207, 2.28691005706787, -1.32246005535126),
    c(0.414463996887207, 2.28691005706787, 1.32246005535126),
    c(0.414929002523422, 2.33612990379333, -1.32395005226135),
    c(0.414929002523422, 2.33612990379333, 1.32395005226135),
    c(0.420890986919403, 2.46093988418579, -0.179077997803688),
    c(0.420890986919403, 2.46093988418579, 0.179077997803688),
    c(0.425177007913589, 2.33612990379333, -1.35664999485016),
    c(0.425177007913589, 2.33612990379333, 1.35664999485016),
    c(0.438241004943848, 2.46093988418579, -0.0912069976329803),
    c(0.438241004943848, 2.46093988418579, 0.0912069976329803),
    c(0.439617991447449, 2.28691005706787, -1.40271997451782),
    c(0.439617991447449, 2.28691005706787, 1.40271997451782),
    c(0.453828006982803, 2.33906006813049, -1.06664001941681),
    c(0.453828006982803, 2.33906006813049, 1.06664001941681),
    c(0.456250011920929, 2.46093988418579, 0),
    c(0.458833009004593, 0.042773000895977, -1.46403002738953),
    c(0.458833009004593, 0.042773000895977, 1.46403002738953),
    c(0.464062988758087, 2.40000009536743, -0.685781002044678),
    c(0.464062988758087, 2.40000009536743, 0.685781002044678),
    c(0.473022997379303, 2.36952996253967, -0.868654012680054),
    c(0.473022997379303, 2.36952996253967, 0.868654012680054),
    c(0.491907000541687, 2.43046998977661, -0.4064100086689),
    c(0.491907000541687, 2.43046998977661, 0.4064100086689),
    c(0.494917988777161, 2.29979991912842, -1.16322004795074),
    c(0.494917988777161, 2.29979991912842, 1.16322004795074),
    c(0.49609899520874, 0.159961000084877, -1.58293998241425),
    c(0.49609899520874, 0.159961000084877, 1.58293998241425),
    c(0.498427987098694, 1.86093997955322, -1.59037005901337),
    c(0.498427987098694, 1.86093997955322, 1.59037005901337),
    c(0.510249972343445, 2.25, -1.19924998283386),
    c(0.510249972343445, 2.25, 1.19924998283386),
    c(0.541833996772766, 2.32382988929749, -1.27348005771637),
    c(0.541833996772766, 2.32382988929749, 1.27348005771637),
    c(0.547339022159576, 0.343944996595383, -1.74644005298615),
    c(0.547339022159576, 0.343944996595383, 1.74644005298615),
    c(0.549499988555908, 2.25, -1.29149997234344),
    c(0.549499988555908, 2.25, 1.29149997234344),
    c(0.550727009773254, 2.34843993186951, -1.2943799495697),
    c(0.550727009773254, 2.34843993186951, 1.2943799495697),
    c(0.559973001480103, 2.43046998977661, -0.304711014032364),
    c(0.559973001480103, 2.43046998977661, 0.304711014032364),
    c(0.566554009914398, 1.28612995147705, -1.80774998664856),
    c(0.566554009914398, 1.28612995147705, 1.80774998664856),
    c(0.568817973136902, 2.32382988929749, -1.33689999580383),
    c(0.568817973136902, 2.32382988929749, 1.33689999580383),
    c(0.577103972434998, 2.31943011283875, -1.05979001522064),
    c(0.577103972434998, 2.31943011283875, 1.05979001522064),
    c(0.581402003765106, 0.5225830078125, -1.85511994361877),
    c(0.581402003765106, 0.5225830078125, 1.85511994361877),
    c(0.585749983787537, 2.40000009536743, -0.585749983787537),
    c(0.585749983787537, 2.40000009536743, 0.585749983787537),
    c(0.588750004768372, 0, -1.38374996185303),
    c(0.588750004768372, 0, 1.38374996185303),
    c(0.588750004768372, 2.25, -1.38374996185303),
    c(0.588750004768372, 2.25, 1.38374996185303),
    c(0.58984500169754, 0.925194978713989, -1.88206005096436),
    c(0.58984500169754, 0.925194978713989, 1.88206005096436),
    c(0.593047022819519, 0.670825004577637, -1.89227998256683),
    c(0.593047022819519, 0.670825004577637, 1.89227998256683),
    c(0.607173979282379, 2.43046998977661, -0.190548002719879),
    c(0.607173979282379, 2.43046998977661, 0.190548002719879),
    c(0.611424028873444, 2.27489995956421, -1.12281000614166),
    c(0.611424028873444, 2.27489995956421, 1.12281000614166),
    c(0.61941397190094, 0.085547000169754, -1.45581996440887),
    c(0.61941397190094, 0.085547000169754, 1.45581996440887),
    c(0.630285024642944, 2.36952996253967, -0.763400018215179),
    c(0.630285024642944, 2.36952996253967, 0.763400018215179),
    c(0.631998002529144, 2.43046998977661, -0.0648249983787537),
    c(0.631998002529144, 2.43046998977661, 0.0648249983787537),
    c(0.650390982627869, 2.33906006813049, -0.961133003234863),
    c(0.650390982627869, 2.33906006813049, 0.961133003234863),
    c(0.663837015628815, 2.28691005706787, -1.21905994415283),
    c(0.663837015628815, 2.28691005706787, 1.21905994415283),
    c(0.664583027362823, 2.33612990379333, -1.22043001651764),
    c(0.664583027362823, 2.33612990379333, 1.22043001651764),
    c(0.680997014045715, 2.33612990379333, -1.25057005882263),
    c(0.680997014045715, 2.33612990379333, 1.25057005882263),
    c(0.685781002044678, 2.40000009536743, -0.464062988758087),
    c(0.685781002044678, 2.40000009536743, 0.464062988758087),
    c(0.686874985694885, 0.234375, -1.61436998844147),
    c(0.686874985694885, 0.234375, 1.61436998844147),
    c(0.704126000404358, 2.28691005706787, -1.29305005073547),
    c(0.704126000404358, 2.28691005706787, 1.29305005073547),
    c(0.709276974201202, 2.29979991912842, -1.04814994335175),
    c(0.709276974201202, 2.29979991912842, 1.04814994335175),
    c(0.723671972751617, 1.47186994552612, -1.70086002349854),
    c(0.723671972751617, 1.47186994552612, 1.70086002349854),
    c(0.731249988079071, 2.25, -1.08062994480133),
    c(0.731249988079071, 2.25, 1.08062994480133),
    c(0.734902024269104, 0.042773000895977, -1.34957003593445),
    c(0.734902024269104, 0.042773000895977, 1.34957003593445),
    c(0.754335999488831, 0.453516006469727, -1.77293002605438),
    c(0.754335999488831, 0.453516006469727, 1.77293002605438),
    c(0.761062979698181, 2.40000009536743, -0.323812991380692),
    c(0.761062979698181, 2.40000009536743, 0.323812991380692),
    c(0.763400018215179, 2.36952996253967, -0.630285024642944),
    c(0.763400018215179, 2.36952996253967, 0.630285024642944),
    c(0.768135011196136, 1.10038995742798, -1.80535995960236),
    c(0.768135011196136, 1.10038995742798, 1.80535995960236),
    c(0.768967986106873, 2.31943011283875, -0.931373000144958),
    c(0.768967986106873, 2.31943011283875, 0.931373000144958),
    c(0.776513993740082, 2.32382988929749, -1.14751994609833),
    c(0.776513993740082, 2.32382988929749, 1.14751994609833),
    c(0.776566982269287, 0.591650009155273, -1.82518005371094),
    c(0.776566982269287, 0.591650009155273, 1.82518005371094),
    c(0.785000026226044, 0.75, -1.84500002861023),
    c(0.785000026226044, 0.75, 1.84500002861023),
    c(0.787500023841858, 2.25, -1.16375005245209),
    c(0.787500023841858, 2.25, 1.16375005245209),
    c(0.789258003234863, 2.34843993186951, -1.16635000705719),
    c(0.789258003234863, 2.34843993186951, 1.16635000705719),
    c(0.794589996337891, 0.159961000084877, -1.45916998386383),
    c(0.794589996337891, 0.159961000084877, 1.45916998386383),
    c(0.79831999540329, 1.86093997955322, -1.46601998806),
    c(0.79831999540329, 1.86093997955322, 1.46601998806),
    c(0.808499991893768, 2.40000009536743, -0.168093994259834),
    c(0.808499991893768, 2.40000009536743, 0.168093994259834),
    c(0.814697980880737, 2.27489995956421, -0.986760973930359),
    c(0.814697980880737, 2.27489995956421, 0.986760973930359),
    c(0.815186023712158, 2.32382988929749, -1.20466005802155),
    c(0.815186023712158, 2.32382988929749, 1.20466005802155),
    c(0.820937991142273, 2.33906006813049, -0.820937991142273),
    c(0.820937991142273, 2.33906006813049, 0.820937991142273),
    c(0.824999988079071, 2.40000009536743, 0),
    c(0.84375, 0, -1.24688005447388),
    c(0.84375, 0, 1.24688005447388),
    c(0.84375, 2.25, -1.24688005447388),
    c(0.84375, 2.25, 1.24688005447388),
    c(0.868654012680054, 2.36952996253967, -0.473022997379303),
    c(0.868654012680054, 2.36952996253967, 0.473022997379303),
    c(0.876659989356995, 0.343944996595383, -1.60988998413086),
    c(0.876659989356995, 0.343944996595383, 1.60988998413086),
    c(0.884536981582642, 2.28691005706787, -1.07134997844696),
    c(0.884536981582642, 2.28691005706787, 1.07134997844696),
    c(0.885531008243561, 2.33612990379333, -1.07255005836487),
    c(0.885531008243561, 2.33612990379333, 1.07255005836487),
    c(0.887695014476776, 0.085547000169754, -1.3118200302124),
    c(0.887695014476776, 0.085547000169754, 1.3118200302124),
    c(0.895265996456146, 2.29979991912842, -0.895265996456146),
    c(0.895265996456146, 2.29979991912842, 0.895265996456146),
    c(0.907401978969574, 2.33612990379333, -1.09904003143311),
    c(0.907401978969574, 2.33612990379333, 1.09904003143311),
    c(0.907437026500702, 1.28612995147705, -1.66639995574951),
    c(0.907437026500702, 1.28612995147705, 1.66639995574951),
    c(0.922999978065491, 2.25, -0.922999978065491),
    c(0.922999978065491, 2.25, 0.922999978065491),
    c(0.931218028068542, 0.5225830078125, -1.71008002758026),
    c(0.931218028068542, 0.5225830078125, 1.71008002758026),
    c(0.931373000144958, 2.31943011283875, -0.768967986106873),
    c(0.931373000144958, 2.31943011283875, 0.768967986106873),
    c(0.938220024108887, 2.28691005706787, -1.13636994361877),
    c(0.938220024108887, 2.28691005706787, 1.13636994361877),
    c(0.942332029342651, 2.36952996253967, -0.295329988002777),
    c(0.942332029342651, 2.36952996253967, 0.295329988002777),
    c(0.944741010665894, 0.925194978713989, -1.7349100112915),
    c(0.944741010665894, 0.925194978713989, 1.7349100112915),
    c(0.949871003627777, 0.670825004577637, -1.7443300485611),
    c(0.949871003627777, 0.670825004577637, 1.7443300485611),
    c(0.961133003234863, 2.33906006813049, -0.650390982627869),
    c(0.961133003234863, 2.33906006813049, 0.650390982627869),
    c(0.979228973388672, 0.042773000895977, -1.18604004383087),
    c(0.979228973388672, 0.042773000895977, 1.18604004383087),
    c(0.98013299703598, 2.32382988929749, -0.98013299703598),
    c(0.98013299703598, 2.32382988929749, 0.98013299703598),
    c(0.980718970298767, 2.36952996253967, -0.100919999182224),
    c(0.980718970298767, 2.36952996253967, 0.100919999182224),
    c(0.984375, 0.234375, -1.45468997955322),
    c(0.984375, 0.234375, 1.45468997955322),
    c(0.986760973930359, 2.27489995956421, -0.814697980880737),
    c(0.986760973930359, 2.27489995956421, 0.814697980880737),
    c(0.994000017642975, 2.25, -0.994000017642975),
    c(0.994000017642975, 2.25, 0.994000017642975),
    c(0.996218979358673, 2.34843993186951, -0.996218979358673),
    c(0.996218979358673, 2.34843993186951, 0.996218979358673),
    c(1.02893996238708, 2.32382988929749, -1.02893996238708),
    c(1.02893996238708, 2.32382988929749, 1.02893996238708),
    c(1.03710997104645, 1.47186994552612, -1.53261995315552),
    c(1.03710997104645, 1.47186994552612, 1.53261995315552),
    c(1.04814994335175, 2.29979991912842, -0.709276974201202),
    c(1.04814994335175, 2.29979991912842, 0.709276974201202),
    c(1.05876004695892, 0.159961000084877, -1.28236997127533),
    c(1.05876004695892, 0.159961000084877, 1.28236997127533),
    c(1.05979001522064, 2.31943011283875, -0.577103972434998),
    c(1.05979001522064, 2.31943011283875, 0.577103972434998),
    c(1.06373000144958, 1.86093997955322, -1.28839004039764),
    c(1.06373000144958, 1.86093997955322, 1.28839004039764),
    c(1.06500005722046, 0, -1.06500005722046),
    c(1.06500005722046, 0, 1.06500005722046),
    c(1.06500005722046, 2.25, -1.06500005722046),
    c(1.06500005722046, 2.25, 1.06500005722046),
    c(1.06664001941681, 2.33906006813049, -0.453828006982803),
    c(1.06664001941681, 2.33906006813049, 0.453828006982803),
    c(1.07134997844696, 2.28691005706787, -0.884536981582642),
    c(1.07134997844696, 2.28691005706787, 0.884536981582642),
    c(1.07255005836487, 2.33612990379333, -0.885531008243561),
    c(1.07255005836487, 2.33612990379333, 0.885531008243561),
    c(1.08062994480133, 2.25, -0.731249988079071),
    c(1.08062994480133, 2.25, 0.731249988079071),
    c(1.08106005191803, 0.453516006469727, -1.59756004810333),
    c(1.08106005191803, 0.453516006469727, 1.59756004810333),
    c(1.09904003143311, 2.33612990379333, -0.907401978969574),
    c(1.09904003143311, 2.33612990379333, 0.907401978969574),
    c(1.10082995891571, 1.10038995742798, -1.62678003311157),
    c(1.10082995891571, 1.10038995742798, 1.62678003311157),
    c(1.11292004585266, 0.591650009155273, -1.64463996887207),
    c(1.11292004585266, 0.591650009155273, 1.64463996887207),
    c(1.12047004699707, 0.085547000169754, -1.12047004699707),
    c(1.12047004699707, 0.085547000169754, 1.12047004699707),
    c(1.12281000614166, 2.27489995956421, -0.611424028873444),
    c(1.12281000614166, 2.27489995956421, 0.611424028873444),
    c(1.125, 0.75, -1.66250002384186),
    c(1.125, 0.75, 1.66250002384186),
    c(1.13311994075775, 2.33906006813049, -0.235586002469063),
    c(1.13311994075775, 2.33906006813049, 0.235586002469063),
    c(1.13636994361877, 2.28691005706787, -0.938220024108887),
    c(1.13636994361877, 2.28691005706787, 0.938220024108887),
    c(1.14751994609833, 2.32382988929749, -0.776513993740082),
    c(1.14751994609833, 2.32382988929749, 0.776513993740082),
    c(1.14968001842499, 2.31943011283875, -0.360312014818192),
    c(1.14968001842499, 2.31943011283875, 0.360312014818192),
    c(1.15625, 2.33906006813049, 0),
    c(1.16322004795074, 2.29979991912842, -0.494917988777161),
    c(1.16322004795074, 2.29979991912842, 0.494917988777161),
    c(1.16375005245209, 2.25, -0.787500023841858),
    c(1.16375005245209, 2.25, 0.787500023841858),
    c(1.16635000705719, 2.34843993186951, -0.789258003234863),
    c(1.16635000705719, 2.34843993186951, 0.789258003234863),
    c(1.16812002658844, 0.343944996595383, -1.41481995582581),
    c(1.16812002658844, 0.343944996595383, 1.41481995582581),
    c(1.18604004383087, 0.042773000895977, -0.979228973388672),
    c(1.18604004383087, 0.042773000895977, 0.979228973388672),
    c(1.19650995731354, 2.31943011283875, -0.123125001788139),
    c(1.19650995731354, 2.31943011283875, 0.123125001788139),
    c(1.19924998283386, 2.25, -0.510249972343445),
    c(1.19924998283386, 2.25, 0.510249972343445),
    c(1.20466005802155, 2.32382988929749, -0.815186023712158),
    c(1.20466005802155, 2.32382988929749, 0.815186023712158),
    c(1.20912003517151, 1.28612995147705, -1.4644900560379),
    c(1.20912003517151, 1.28612995147705, 1.4644900560379),
    c(1.21805000305176, 2.27489995956421, -0.381740003824234),
    c(1.21805000305176, 2.27489995956421, 0.381740003824234),
    c(1.21905994415283, 2.28691005706787, -0.663837015628815),
    c(1.21905994415283, 2.28691005706787, 0.663837015628815),
    c(1.22043001651764, 2.33612990379333, -0.664583027362823),
    c(1.22043001651764, 2.33612990379333, 0.664583027362823),
    c(1.235720038414, 2.29979991912842, -0.256915986537933),
    c(1.235720038414, 2.29979991912842, 0.256915986537933),
    c(1.24081003665924, 0.5225830078125, -1.50286996364594),
    c(1.24081003665924, 0.5225830078125, 1.50286996364594),
    c(1.24249994754791, 0.234375, -1.24249994754791),
    c(1.24249994754791, 0.234375, 1.24249994754791),
    c(1.24688005447388, 0, -0.84375),
    c(1.24688005447388, 0, 0.84375),
    c(1.24688005447388, 2.25, -0.84375),
    c(1.24688005447388, 2.25, 0.84375),
    c(1.25057005882263, 2.33612990379333, -0.680997014045715),
    c(1.25057005882263, 2.33612990379333, 0.680997014045715),
    c(1.25882995128632, 0.925194978713989, -1.52469003200531),
    c(1.25882995128632, 0.925194978713989, 1.52469003200531),
    c(1.26093995571136, 2.29979991912842, 0),
    c(1.26566994190216, 0.670825004577637, -1.53296995162964),
    c(1.26566994190216, 0.670825004577637, 1.53296995162964),
    c(1.26766002178192, 2.27489995956421, -0.130447998642921),
    c(1.26766002178192, 2.27489995956421, 0.130447998642921),
    c(1.27348005771637, 2.32382988929749, -0.541833996772766),
    c(1.27348005771637, 2.32382988929749, 0.541833996772766),
    c(1.27400004863739, 2.25, -0.264874994754791),
    c(1.27400004863739, 2.25, 0.264874994754791),
    c(1.28236997127533, 0.159961000084877, -1.05876004695892),
    c(1.28236997127533, 0.159961000084877, 1.05876004695892),
    c(1.28839004039764, 1.86093997955322, -1.06373000144958),
    c(1.28839004039764, 1.86093997955322, 1.06373000144958),
    c(1.29149997234344, 2.25, -0.549499988555908),
    c(1.29149997234344, 2.25, 0.549499988555908),
    c(1.29305005073547, 2.28691005706787, -0.704126000404358),
    c(1.29305005073547, 2.28691005706787, 0.704126000404358),
    c(1.2943799495697, 2.34843993186951, -0.550727009773254),
    c(1.2943799495697, 2.34843993186951, 0.550727009773254),
    c(1.29999995231628, 2.25, 0),
    c(1.30905997753143, 1.47186994552612, -1.30905997753143),
    c(1.30905997753143, 1.47186994552612, 1.30905997753143),
    c(1.3118200302124, 0.085547000169754, -0.887695014476776),
    c(1.3118200302124, 0.085547000169754, 0.887695014476776),
    c(1.32246005535126, 2.28691005706787, -0.414463996887207),
    c(1.32246005535126, 2.28691005706787, 0.414463996887207),
    c(1.32395005226135, 2.33612990379333, -0.414929002523422),
    c(1.32395005226135, 2.33612990379333, 0.414929002523422),
    c(1.33689999580383, 2.32382988929749, -0.568817973136902),
    c(1.33689999580383, 2.32382988929749, 0.568817973136902),
    c(1.34957003593445, 0.042773000895977, -0.734902024269104),
    c(1.34957003593445, 0.042773000895977, 0.734902024269104),
    c(1.35285997390747, 2.32382988929749, -0.281271010637283),
    c(1.35285997390747, 2.32382988929749, 0.281271010637283),
    c(1.35664999485016, 2.33612990379333, -0.425177007913589),
    c(1.35664999485016, 2.33612990379333, 0.425177007913589),
    c(1.36452996730804, 0.453516006469727, -1.36452996730804),
    c(1.36452996730804, 0.453516006469727, 1.36452996730804),
    c(1.37199997901917, 2.25, -0.285250008106232),
    c(1.37199997901917, 2.25, 0.285250008106232),
    c(1.37505996227264, 2.34843993186951, -0.285887002944946),
    c(1.37505996227264, 2.34843993186951, 0.285887002944946),
    c(1.37633001804352, 2.28691005706787, -0.141629993915558),
    c(1.37633001804352, 2.28691005706787, 0.141629993915558),
    c(1.37787997722626, 2.33612990379333, -0.141789004206657),
    c(1.37787997722626, 2.33612990379333, 0.141789004206657),
    c(1.38047003746033, 2.32382988929749, 0),
    c(1.38374996185303, 0, -0.588750004768372),
    c(1.38374996185303, 0, 0.588750004768372),
    c(1.38374996185303, 2.25, -0.588750004768372),
    c(1.38374996185303, 2.25, 0.588750004768372),
    c(1.38949000835419, 1.10038995742798, -1.38949000835419),
    c(1.38949000835419, 1.10038995742798, 1.38949000835419),
    c(1.39999997615814, 2.25, 0),
    c(1.40271997451782, 2.28691005706787, -0.439617991447449),
    c(1.40271997451782, 2.28691005706787, 0.439617991447449),
    c(1.40313005447388, 2.34843993186951, 0),
    c(1.40474998950958, 0.591650009155273, -1.40474998950958),
    c(1.40474998950958, 0.591650009155273, 1.40474998950958),
    c(1.41191005706787, 2.33612990379333, -0.14529100060463),
    c(1.41191005706787, 2.33612990379333, 0.14529100060463),
    c(1.41481995582581, 0.343944996595383, -1.16812002658844),
    c(1.41481995582581, 0.343944996595383, 1.16812002658844),
    c(1.41999995708466, 0.75, -1.41999995708466),
    c(1.41999995708466, 0.75, 1.41999995708466),
    c(1.42023003101349, 2.32382988929749, -0.295278012752533),
    c(1.42023003101349, 2.32382988929749, 0.295278012752533),
    c(1.4492199420929, 2.32382988929749, 0),
    c(1.45468997955322, 0.234375, -0.984375),
    c(1.45468997955322, 0.234375, 0.984375),
    c(1.45581996440887, 0.085547000169754, -0.61941397190094),
    c(1.45581996440887, 0.085547000169754, 0.61941397190094),
    c(1.45916998386383, 0.159961000084877, -0.794589996337891),
    c(1.45916998386383, 0.159961000084877, 0.794589996337891),
    c(1.45985996723175, 2.28691005706787, -0.15022599697113),
    c(1.45985996723175, 2.28691005706787, 0.15022599697113),
    c(1.46403002738953, 0.042773000895977, -0.458833009004593),
    c(1.46403002738953, 0.042773000895977, 0.458833009004593),
    c(1.4644900560379, 1.28612995147705, -1.20912003517151),
    c(1.4644900560379, 1.28612995147705, 1.20912003517151),
    c(1.46601998806, 1.86093997955322, -0.79831999540329),
    c(1.46601998806, 1.86093997955322, 0.79831999540329),
    c(1.47000002861023, 0, -0.30562499165535),
    c(1.47000002861023, 0, 0.30562499165535),
    c(1.47000002861023, 2.25, -0.30562499165535),
    c(1.47000002861023, 2.25, 0.30562499165535),
    c(1.5, 0, 0),
    c(1.5, 2.25, 0),
    c(1.50286996364594, 0.5225830078125, -1.24081003665924),
    c(1.50286996364594, 0.5225830078125, 1.24081003665924),
    c(1.52366995811462, 0.042773000895977, -0.156791999936104),
    c(1.52366995811462, 0.042773000895977, 0.156791999936104),
    c(1.52469003200531, 0.925194978713989, -1.25882995128632),
    c(1.52469003200531, 0.925194978713989, 1.25882995128632),
    c(1.53261995315552, 1.47186994552612, -1.03710997104645),
    c(1.53261995315552, 1.47186994552612, 1.03710997104645),
    c(1.53296995162964, 0.670825004577637, -1.26566994190216),
    c(1.53296995162964, 0.670825004577637, 1.26566994190216),
    c(1.54656004905701, 0.085547000169754, -0.321543008089066),
    c(1.54656004905701, 0.085547000169754, 0.321543008089066),
    c(1.57813000679016, 0.085547000169754, 0),
    c(1.58293998241425, 0.159961000084877, -0.49609899520874),
    c(1.58293998241425, 0.159961000084877, 0.49609899520874),
    c(1.59037005901337, 1.86093997955322, -0.498427987098694),
    c(1.59037005901337, 1.86093997955322, 0.498427987098694),
    c(1.59756004810333, 0.453516006469727, -1.08106005191803),
    c(1.59756004810333, 0.453516006469727, 1.08106005191803),
    c(1.60988998413086, 0.343944996595383, -0.876659989356995),
    c(1.60988998413086, 0.343944996595383, 0.876659989356995),
    c(1.61436998844147, 0.234375, -0.686874985694885),
    c(1.61436998844147, 0.234375, 0.686874985694885),
    c(1.62678003311157, 1.10038995742798, -1.10082995891571),
    c(1.62678003311157, 1.10038995742798, 1.10082995891571),
    c(1.64463996887207, 0.591650009155273, -1.11292004585266),
    c(1.64463996887207, 0.591650009155273, 1.11292004585266),
    c(1.64742004871368, 0.159961000084877, -0.169525995850563),
    c(1.64742004871368, 0.159961000084877, 0.169525995850563),
    c(1.65515995025635, 1.86093997955322, -0.170322000980377),
    c(1.65515995025635, 1.86093997955322, 0.170322000980377),
    c(1.66250002384186, 0.75, -1.125),
    c(1.66250002384186, 0.75, 1.125),
    c(1.66639995574951, 1.28612995147705, -0.907437026500702),
    c(1.66639995574951, 1.28612995147705, 0.907437026500702),
    c(1.70000004768372, 0.449999988079071, 0),
    c(1.70000004768372, 0.485448986291885, -0.216563001275063),
    c(1.70000004768372, 0.485448986291885, 0.216563001275063),
    c(1.70000004768372, 0.578905999660492, -0.371250003576279),
    c(1.70000004768372, 0.578905999660492, 0.371250003576279),
    c(1.70000004768372, 0.711035013198853, -0.464062988758087),
    c(1.70000004768372, 0.711035013198853, 0.464062988758087),
    c(1.70000004768372, 0.862500011920929, -0.495000004768372),
    c(1.70000004768372, 0.862500011920929, 0.495000004768372),
    c(1.70000004768372, 1.01397001743317, -0.464062988758087),
    c(1.70000004768372, 1.01397001743317, 0.464062988758087),
    c(1.70000004768372, 1.14609003067017, -0.371250003576279),
    c(1.70000004768372, 1.14609003067017, 0.371250003576279),
    c(1.70000004768372, 1.23954999446869, -0.216563001275063),
    c(1.70000004768372, 1.23954999446869, 0.216563001275063),
    c(1.70000004768372, 1.27499997615814, 0),
    c(1.70086002349854, 1.47186994552612, -0.723671972751617),
    c(1.70086002349854, 1.47186994552612, 0.723671972751617),
    c(1.71008002758026, 0.5225830078125, -0.931218028068542),
    c(1.71008002758026, 0.5225830078125, 0.931218028068542),
    c(1.7150000333786, 0.234375, -0.356561988592148),
    c(1.7150000333786, 0.234375, 0.356563001871109),
    c(1.7349100112915, 0.925194978713989, -0.944741010665894),
    c(1.7349100112915, 0.925194978713989, 0.944741010665894),
    c(1.7443300485611, 0.670825004577637, -0.949871003627777),
    c(1.7443300485611, 0.670825004577637, 0.949871003627777),
    c(1.74644005298615, 0.343944996595383, -0.547339022159576),
    c(1.74644005298615, 0.343944996595383, 0.547339022159576),
    c(1.75, 0.234375, 0),
    c(1.77293002605438, 0.453516006469727, -0.754335999488831),
    c(1.77293002605438, 0.453516006469727, 0.754335999488831),
    c(1.80535995960236, 1.10038995742798, -0.768135011196136),
    c(1.80535995960236, 1.10038995742798, 0.768135011196136),
    c(1.8068699836731, 1.47186994552612, -0.375663995742798),
    c(1.8068699836731, 1.47186994552612, 0.375663995742798),
    c(1.80774998664856, 1.28612995147705, -0.566554009914398),
    c(1.80774998664856, 1.28612995147705, 0.566554009914398),
    c(1.80868005752563, 0.669439971446991, -0.41533499956131),
    c(1.80868005752563, 0.669439971446991, 0.41533499956131),
    c(1.81523001194, 0.556497991085052, -0.292881011962891),
    c(1.81523001194, 0.556497991085052, 0.292881011962891),
    c(1.81757998466492, 0.343944996595383, -0.187035992741585),
    c(1.81757998466492, 0.343944996595383, 0.187035992741585),
    c(1.81850004196167, 0.493822991847992, -0.107904002070427),
    c(1.81850004196167, 0.493822991847992, 0.107904002070427),
    c(1.82518005371094, 0.591650009155273, -0.776566982269287),
    c(1.82518005371094, 0.591650009155273, 0.776566982269287),
    c(1.84375, 1.47186994552612, 0),
    c(1.84407997131348, 1.2731100320816, -0.106835998594761),
    c(1.84407997131348, 1.2731100320816, 0.106835998594761),
    c(1.84500002861023, 0.75, -0.785000026226044),
    c(1.84500002861023, 0.75, 0.785000026226044),
    c(1.8498899936676, 1.21245002746582, -0.289983987808228),
    c(1.8498899936676, 1.21245002746582, 0.289983987808228),
    c(1.85511994361877, 0.5225830078125, -0.581402003765106),
    c(1.85511994361877, 0.5225830078125, 0.581402003765106),
    c(1.86006999015808, 1.10627996921539, -0.412081986665726),
    c(1.86006999015808, 1.10627996921539, 0.412081986665726),
    c(1.87285995483398, 0.972819983959198, -0.473131000995636),
    c(1.87285995483398, 0.972819983959198, 0.473131000995636),
    c(1.88138997554779, 1.28612995147705, -0.193601995706558),
    c(1.88138997554779, 1.28612995147705, 0.193601995706558),
    c(1.88206005096436, 0.925194978713989, -0.58984500169754),
    c(1.88206005096436, 0.925194978713989, 0.58984500169754),
    c(1.8834400177002, 0.453516006469727, -0.391582012176514),
    c(1.8834400177002, 0.453516006469727, 0.391582012176514),
    c(1.88652002811432, 0.830256998538971, -0.473131000995636),
    c(1.88652002811432, 0.830256998538971, 0.473131000995636),
    c(1.89227998256683, 0.670825004577637, -0.593047022819519),
    c(1.89227998256683, 0.670825004577637, 0.593047022819519),
    c(1.90898001194, 0.762850999832153, -0.457367986440659),
    c(1.90898001194, 0.762850999832153, 0.457367986440659),
    c(1.91788995265961, 1.10038995742798, -0.398745000362396),
    c(1.91788995265961, 1.10038995742798, 0.398745000362396),
    c(1.92188000679016, 0.453516006469727, 0),
    c(1.92571997642517, 0.624967992305756, -0.368660002946854),
    c(1.92571997642517, 0.624967992305756, 0.368660002946854),
    c(1.93069005012512, 0.5225830078125, -0.198676005005836),
    c(1.93069005012512, 0.5225830078125, 0.198676005005836),
    c(1.93519997596741, 0.536666989326477, -0.215051993727684),
    c(1.93519997596741, 0.536666989326477, 0.215051993727684),
    c(1.93878996372223, 0.503174006938934, 0),
    c(1.93894994258881, 0.591650009155273, -0.403122991323471),
    c(1.93894994258881, 0.591650009155273, 0.403122991323471),
    c(1.9570300579071, 1.10038995742798, 0),
    c(1.9587299823761, 0.925194978713989, -0.201561003923416),
    c(1.9587299823761, 0.925194978713989, 0.201561003923416),
    c(1.96000003814697, 0.75, -0.407499998807907),
    c(1.96000003814697, 0.75, 0.407499998807907),
    c(1.96937000751495, 0.670825004577637, -0.202656000852585),
    c(1.96937000751495, 0.670825004577637, 0.202656000852585),
    c(1.97852003574371, 0.591650009155273, 0),
    c(1.98495995998383, 1.30458998680115, 0),
    c(1.99135994911194, 1.27330994606018, -0.210782006382942),
    c(1.99135994911194, 1.27330994606018, 0.210782006382942),
    c(2, 0.75, 0),
    c(2.00798988342285, 0.721262991428375, -0.409761011600494),
    c(2.00798988342285, 0.721262991428375, 0.409761011600494),
    c(2.00820994377136, 1.19084000587463, -0.36133998632431),
    c(2.00820994377136, 1.19084000587463, 0.36133998632431),
    c(2.02470993995667, 0.614948987960815, -0.288958013057709),
    c(2.02470993995667, 0.614948987960815, 0.288958013057709),
    c(2.03204989433289, 1.07423996925354, -0.451674997806549),
    c(2.03204989433289, 1.07423996925354, 0.451674997806549),
    c(2.03379011154175, 0.556061983108521, -0.106458000838757),
    c(2.03379011154175, 0.556061983108521, 0.106458000838757),
    c(2.05938005447388, 0.940576016902924, -0.481786996126175),
    c(2.05938005447388, 0.940576016902924, 0.481786996126175),
    c(2.08644008636475, 1.33047997951508, -0.101580999791622),
    c(2.08644008636475, 1.33047997951508, 0.101580999791622),
    c(2.08669996261597, 0.806914985179901, -0.451674997806549),
    c(2.08669996261597, 0.806914985179901, 0.451674997806549),
    c(2.10140991210938, 1.27814996242523, -0.275720000267029),
    c(2.10140991210938, 1.27814996242523, 0.275720000267029),
    c(2.11052989959717, 0.69031697511673, -0.36133998632431),
    c(2.11052989959717, 0.69031697511673, 0.36133998632431),
    c(2.12738990783691, 0.60784500837326, -0.210782006382942),
    c(2.12738990783691, 0.60784500837326, 0.210782006382942),
    c(2.1275999546051, 1.18656003475189, -0.39181199669838),
    c(2.1275999546051, 1.18656003475189, 0.39181199669838),
    c(2.13379001617432, 0.576563000679016, 0),
    c(2.16054010391235, 1.07142996788025, -0.449858993291855),
    c(2.16054010391235, 1.07142996788025, 0.449858993291855),
    c(2.16921997070312, 0.790259003639221, -0.399360001087189),
    c(2.16921997070312, 0.790259003639221, 0.399360001087189),
    c(2.17968988418579, 1.38515996932983, 0),
    c(2.1897599697113, 1.35887002944946, -0.195541992783546),
    c(2.1897599697113, 1.35887002944946, 0.195541992783546),
    c(2.19480991363525, 0.691761016845703, -0.281558990478516),
    c(2.19480991363525, 0.691761016845703, 0.281558990478516),
    c(2.19570994377136, 0.948444008827209, -0.449858993291855),
    c(2.19570994377136, 0.948444008827209, 0.449858993291855),
    c(2.20836997032166, 0.637081980705261, -0.103731997311115),
    c(2.20836997032166, 0.637081980705261, 0.103731997311115),
    c(2.21631002426147, 1.28956997394562, -0.335215002298355),
    c(2.21631002426147, 1.28956997394562, 0.335215002298355),
    c(2.2202000617981, 0.891314029693604, -0.434457004070282),
    c(2.2202000617981, 0.891314029693604, 0.434457004070282),
    c(2.24856996536255, 1.43299996852875, -0.0923840031027794),
    c(2.24856996536255, 1.43299996852875, 0.0923840031027794),
    c(2.25383996963501, 1.19159996509552, -0.419019013643265),
    c(2.25383996963501, 1.19159996509552, 0.419019013643265),
    c(2.25943994522095, 0.772489011287689, -0.349967002868652),
    c(2.25943994522095, 0.772489011287689, 0.349967002868652),
    c(2.26856994628906, 1.39015996456146, -0.250757992267609),
    c(2.26856994628906, 1.39015996456146, 0.250757992267609),
    c(2.28188991546631, 0.696393013000488, -0.20414699614048),
    c(2.28188991546631, 0.696393013000488, 0.20414699614048),
    c(2.29041004180908, 0.667528986930847, 0),
    c(2.29688000679016, 1.0793000459671, -0.446952998638153),
    c(2.29688000679016, 1.0793000459671, 0.446952998638153),
    c(2.29924988746643, 0.874952971935272, -0.384663999080658),
    c(2.29924988746643, 0.874952971935272, 0.384663999080658),
    c(2.30358004570007, 1.31519997119904, -0.356339991092682),
    c(2.30358004570007, 1.31519997119904, 0.356339991092682),
    c(2.30644011497498, 1.50440001487732, 0),
    c(2.31838011741638, 1.48355996608734, -0.17399600148201),
    c(2.31838011741638, 1.48355996608734, 0.17399600148201),
    c(2.33068990707397, 0.784406006336212, -0.271218001842499),
    c(2.33068990707397, 0.784406006336212, 0.271218001842499),
    c(2.33991003036499, 0.966988980770111, -0.419019013643265),
    c(2.33991003036499, 0.966988980770111, 0.419019013643265),
    c(2.34758996963501, 0.734270989894867, -0.0999220013618469),
    c(2.34758996963501, 0.734270989894867, 0.0999220013618469),
    c(2.34758996963501, 1.22096002101898, -0.409130990505219),
    c(2.34758996963501, 1.22096002101898, 0.409130990505219),
    c(2.34983992576599, 1.42864000797272, -0.298278987407684),
    c(2.34983992576599, 1.42864000797272, 0.298278987407684),
    c(2.35317993164062, 1.56816005706787, -0.0808229967951775),
    c(2.35317993164062, 1.56816005706787, 0.0808229967951775),
    c(2.37575006484985, 1.53531002998352, -0.219376996159554),
    c(2.37575006484985, 1.53531002998352, 0.219376996159554),
    c(2.37743997573853, 0.869018971920013, -0.335215002298355),
    c(2.37743997573853, 0.869018971920013, 0.335215002298355),
    c(2.38750004768372, 1.64999997615814, 0),
    c(2.39432001113892, 1.35098004341125, -0.372848987579346),
    c(2.39432001113892, 1.35098004341125, 0.372848987579346),
    c(2.39459991455078, 1.12030005455017, -0.409130990505219),
    c(2.39459991455078, 1.12030005455017, 0.409130990505219),
    c(2.40038990974426, 1.63469004631042, -0.149296998977661),
    c(2.40038990974426, 1.63469004631042, 0.149296998977661),
    c(2.4039900302887, 0.799722015857697, -0.195541992783546),
    c(2.4039900302887, 0.799722015857697, 0.195541992783546),
    c(2.41406011581421, 0.773437976837158, 0),
    c(2.41524004936218, 1.47781002521515, -0.311747014522552),
    c(2.41524004936218, 1.47781002521515, 0.311747014522552),
    c(2.43438005447388, 1.59433996677399, -0.255937993526459),
    c(2.43438005447388, 1.59433996677399, 0.255937993526459),
    c(2.4386100769043, 1.02605998516083, -0.356339991092682),
    c(2.4386100769043, 1.02605998516083, 0.356339991092682),
    c(2.44531011581421, 1.26196002960205, -0.397704988718033),
    c(2.44531011581421, 1.26196002960205, 0.397704988718033),
    c(2.45167994499207, 1.805340051651, -0.0630870014429092),
    c(2.45167994499207, 1.805340051651, 0.0630870014429092),
    c(2.46489000320435, 1.40551996231079, -0.357930988073349),
    c(2.46489000320435, 1.40551996231079, 0.357930988073349),
    c(2.47361993789673, 0.95109897851944, -0.250757992267609),
    c(2.47361993789673, 0.95109897851944, 0.250757992267609),
    c(2.47767996788025, 1.78638005256653, -0.171237006783485),
    c(2.47767996788025, 1.78638005256653, 0.171237006783485),
    c(2.48241996765137, 1.53727996349335, -0.319922000169754),
    c(2.48241996765137, 1.53727996349335, 0.319922000169754),
    c(2.49361991882324, 0.908263981342316, -0.0923840031027794),
    c(2.49361991882324, 0.908263981342316, 0.0923840031027794),
    c(2.49629998207092, 1.17295002937317, -0.372848987579346),
    c(2.49629998207092, 1.17295002937317, 0.372848987579346),
    c(2.50155997276306, 1.97108995914459, 0),
    c(2.5172700881958, 1.9655499458313, -0.103051997721195),
    c(2.5172700881958, 1.9655499458313, 0.103051997721195),
    c(2.51792001724243, 1.32831001281738, -0.357930988073349),
    c(2.51792001724243, 1.32831001281738, 0.357930988073349),
    c(2.52318000793457, 1.75321996212006, -0.243336006999016),
    c(2.52318000793457, 1.75321996212006, 0.243336006999016),
    c(2.53749990463257, 1.47186994552612, -0.341250002384186),
    c(2.53749990463257, 1.47186994552612, 0.341250002384186),
    c(2.54078006744385, 1.09528994560242, -0.298278987407684),
    c(2.54078006744385, 1.09528994560242, 0.298278987407684),
    c(2.5491099357605, 2.0446400642395, -0.047715999186039),
    c(2.5491099357605, 2.0446400642395, 0.047715999186039),
    c(2.55869007110596, 1.95095002651215, -0.176660001277924),
    c(2.55869007110596, 1.95095002651215, 0.176660001277924),
    c(2.56756997108459, 1.25602996349335, -0.311747014522552),
    c(2.56756997108459, 1.25602996349335, 0.311747014522552),
    c(2.57224988937378, 1.04035997390747, -0.17399600148201),
    c(2.57224988937378, 1.04035997390747, 0.17399600148201),
    c(2.57909989356995, 2.1219699382782, 0),
    c(2.58038997650146, 1.71152997016907, -0.279386013746262),
    c(2.58038997650146, 1.71152997016907, 0.279386013746262),
    c(2.58101010322571, 2.0377299785614, -0.129515007138252),
    c(2.58101010322571, 2.0377299785614, 0.129515007138252),
    c(2.58418011665344, 1.0195300579071, 0),
    c(2.59258008003235, 1.40646994113922, -0.319922000169754),
    c(2.59258008003235, 1.40646994113922, 0.319922000169754),
    c(2.59848999977112, 2.11992001533508, -0.0878119990229607),
    c(2.59848999977112, 2.11992001533508, 0.0878119990229607),
    c(2.60177993774414, 1.55472004413605, -0.304019004106522),
    c(2.60177993774414, 1.55472004413605, 0.304019004106522),
    c(2.60706996917725, 1.19852995872498, -0.219376996159554),
    c(2.60706996917725, 1.19852995872498, 0.219376996159554),
    c(2.61161994934082, 1.69128000736237, -0.287907987833023),
    c(2.61161994934082, 1.69128000736237, 0.287907987833023),
    c(2.61724996566772, 1.93031001091003, -0.220825001597404),
    c(2.61724996566772, 1.93031001091003, 0.220825001597404),
    c(2.62963008880615, 1.16568005084991, -0.0808229967951775),
    c(2.62963008880615, 1.16568005084991, 0.0808229967951775),
    c(2.6378800868988, 2.02554988861084, -0.180818006396294),
    c(2.6378800868988, 2.02554988861084, 0.180818006396294),
    c(2.64063000679016, 1.34941005706787, -0.255937993526459),
    c(2.64063000679016, 1.34941005706787, 0.255937993526459),
    c(2.6496000289917, 2.11451005935669, -0.150535002350807),
    c(2.6496000289917, 2.11451005935669, 0.150535002350807),
    c(2.65084004402161, 2.18547010421753, -0.0424610003829002),
    c(2.65084004402161, 2.18547010421753, 0.0424610003829002),
    c(2.65390992164612, 1.50419998168945, -0.264113008975983),
    c(2.65390992164612, 1.50419998168945, 0.264113008975983),
    c(2.6654200553894, 1.64925003051758, -0.266995012760162),
    c(2.6654200553894, 1.64925003051758, 0.266995012760162),
    c(2.67460989952087, 1.30905997753143, -0.149296998977661),
    c(2.67460989952087, 1.30905997753143, 0.149296998977661),
    c(2.67823004722595, 1.78253996372223, -0.252819001674652),
    c(2.67823004722595, 1.78253996372223, 0.252819001674652),
    c(2.68438005447388, 1.90664005279541, -0.235547006130219),
    c(2.68438005447388, 1.90664005279541, 0.235547006130219),
    c(2.6875, 1.29375004768372, 0),
    c(2.69190001487732, 2.18360996246338, -0.115250997245312),
    c(2.69190001487732, 2.18360996246338, 0.115250997245312),
    c(2.69644999504089, 1.46379995346069, -0.185856997966766),
    c(2.69644999504089, 1.46379995346069, 0.185856997966766),
    c(2.70000004768372, 2.25, 0),
    c(2.70808005332947, 2.01037001609802, -0.208084002137184),
    c(2.70808005332947, 2.01037001609802, 0.208084002137184),
    c(2.71703004837036, 1.61167001724243, -0.213596001267433),
    c(2.71703004837036, 1.61167001724243, 0.213596001267433),
    c(2.72076010704041, 1.44071996212006, -0.0684740021824837),
    c(2.72076010704041, 1.44071996212006, 0.0684740021824837),
    c(2.72578001022339, 2.25, -0.0820309966802597),
    c(2.72578001022339, 2.25, 0.0820309966802597),
    c(2.72599005699158, 2.10643005371094, -0.175249993801117),
    c(2.72599005699158, 2.10643005371094, 0.175249993801117),
    c(2.73600006103516, 1.75154995918274, -0.219519004225731),
    c(2.73600006103516, 1.75154995918274, 0.219519004225731),
    c(2.75021004676819, 2.26919007301331, -0.039733998477459),
    c(2.75021004676819, 2.26919007301331, 0.039733998477459),
    c(2.75149989128113, 1.8829699754715, -0.220825001597404),
    c(2.75149989128113, 1.8829699754715, 0.220825001597404),
    c(2.7535400390625, 1.58508002758026, -0.124597996473312),
    c(2.7535400390625, 1.58508002758026, 0.124597996473312),
    c(2.76737999916077, 1.57500004768372, 0),
    c(2.77555990219116, 2.28399991989136, 0),
    c(2.7809898853302, 1.9943699836731, -0.208084002137184),
    c(2.7809898853302, 1.9943699836731, 0.208084002137184),
    c(2.78303003311157, 1.72669994831085, -0.154476001858711),
    c(2.78303003311157, 1.72669994831085, 0.154476001858711),
    c(2.79375004768372, 2.25, -0.140625),
    c(2.79375004768372, 2.25, 0.140625),
    c(2.79782009124756, 2.27174997329712, -0.10784900188446),
    c(2.79782009124756, 2.27174997329712, 0.10784900188446),
    c(2.79948997497559, 2.29274988174438, -0.0769039988517761),
    c(2.79948997497559, 2.29274988174438, 0.0769039988517761),
    c(2.79999995231628, 2.25, 0),
    c(2.80468988418579, 2.09809994697571, -0.200712993741035),
    c(2.80468988418579, 2.09809994697571, 0.200712993741035),
    c(2.8099000453949, 1.71249997615814, -0.0569120012223721),
    c(2.8099000453949, 1.71249997615814, 0.0569120012223721),
    c(2.81006002426147, 1.86232995986938, -0.176660001277924),
    c(2.81006002426147, 1.86232995986938, 0.176660001277924),
    c(2.81201004981995, 2.17814993858337, -0.169843003153801),
    c(2.81201004981995, 2.17814993858337, 0.169843003153801),
    c(2.81274008750916, 2.29753994941711, -0.035631999373436),
    c(2.81274008750916, 2.29753994941711, 0.035631999373436),
    c(2.81718993186951, 2.25, -0.0492190010845661),
    c(2.81718993186951, 2.25, 0.0492190010845661),
    c(2.82500004768372, 2.30625009536743, 0),
    c(2.8301100730896, 2.27129006385803, -0.025891000404954),
    c(2.8301100730896, 2.27129006385803, 0.025891000404954),
    c(2.84063005447388, 2.29219007492065, 0),
    c(2.84478998184204, 2.29963994026184, -0.0299929995089769),
    c(2.84478998184204, 2.29963994026184, 0.0299929995089769),
    c(2.85091996192932, 2.30715990066528, -0.0656249970197678),
    c(2.85091996192932, 2.30715990066528, 0.0656249970197678),
    c(2.85118007659912, 1.97918999195099, -0.180818006396294),
    c(2.85118007659912, 1.97918999195099, 0.180818006396294),
    c(2.85148000717163, 1.84773004055023, -0.103051997721195),
    c(2.85148000717163, 1.84773004055023, 0.103051997721195),
    c(2.86048007011414, 2.30093002319336, -0.0967160016298294),
    c(2.86048007011414, 2.30093002319336, 0.0967160016298294),
    c(2.86249995231628, 2.25, -0.0843750014901161),
    c(2.86249995231628, 2.25, 0.0843750014901161),
    c(2.86262989044189, 2.29297995567322, -0.0543459989130497),
    c(2.86262989044189, 2.29297995567322, 0.0543459989130497),
    c(2.86574006080627, 2.27201008796692, -0.0702759996056557),
    c(2.86574006080627, 2.27201008796692, 0.0702759996056557),
    c(2.86718988418579, 1.84219002723694, 0),
    c(2.87227988243103, 2.29425001144409, -0.131835997104645),
    c(2.87227988243103, 2.29425001144409, 0.131835997104645),
    c(2.88338994979858, 2.08977007865906, -0.175249993801117),
    c(2.88338994979858, 2.08977007865906, 0.175249993801117),
    c(2.88836002349854, 2.30118989944458, -0.0814089998602867),
    c(2.88836002349854, 2.30118989944458, 0.0814089998602867),
    c(2.89826989173889, 2.17088007926941, -0.19438199698925),
    c(2.89826989173889, 2.17088007926941, 0.19438199698925),
    c(2.90805006027222, 1.96700000762939, -0.129515007138252),
    c(2.90805006027222, 1.96700000762939, 0.129515007138252),
    c(2.91923999786377, 2.30955004692078, -0.112499997019768),
    c(2.91923999786377, 2.30955004692078, 0.112499997019768),
    c(2.92063999176025, 2.29506993293762, -0.0931639969348907),
    c(2.92063999176025, 2.29506993293762, 0.0931639969348907),
    c(2.93279004096985, 2.13103008270264, -0.17221100628376),
    c(2.93279004096985, 2.13103008270264, 0.17221100628376),
    c(2.93980002403259, 2.27326011657715, -0.158935993909836),
    c(2.93980002403259, 2.27326011657715, 0.158935993909836),
    c(2.93996000289917, 1.96010005474091, -0.047715999186039),
    c(2.93996000289917, 1.96010005474091, 0.047715999186039),
    c(2.95977997779846, 2.08168005943298, -0.150535002350807),
    c(2.95977997779846, 2.08168005943298, 0.150535002350807),
    c(2.96994996070862, 2.27412009239197, -0.103564001619816),
    c(2.96994996070862, 2.27412009239197, 0.103564001619816),
    c(3, 2.25, -0.1875),
    c(3, 2.25, -0.112499997019768),
    c(3, 2.25, 0.112499997019768),
    c(3, 2.25, 0.1875),
    c(3.00281000137329, 2.30484008789062, -0.142528995871544),
    c(3.00281000137329, 2.30484008789062, 0.142528995871544),
    c(3.01089000701904, 2.07627010345459, -0.0878119990229607),
    c(3.01089000701904, 2.07627010345459, 0.0878119990229607),
    c(3.01577997207642, 2.30571007728577, -0.119970999658108),
    c(3.01577997207642, 2.30571007728577, 0.119970999658108),
    c(3.03027009963989, 2.0742199420929, 0),
    c(3.04150009155273, 2.12566995620728, -0.116276003420353),
    c(3.04150009155273, 2.12566995620728, 0.116276003420353),
    c(3.0432300567627, 2.2110800743103, -0.166430994868279),
    c(3.0432300567627, 2.2110800743103, 0.166430994868279),
    c(3.06841993331909, 2.17344999313354, -0.143215000629425),
    c(3.06841993331909, 2.17344999313354, 0.143215000629425),
    c(3.07928991317749, 2.12305998802185, -0.0428379997611046),
    c(3.07928991317749, 2.12305998802185, 0.0428379997611046),
    c(3.09315991401672, 2.29877996444702, -0.17578099668026),
    c(3.09315991401672, 2.29877996444702, 0.17578099668026),
    c(3.09667992591858, 2.30141997337341, -0.124219000339508),
    c(3.09667992591858, 2.30141997337341, 0.124219000339508),
    c(3.12655997276306, 2.31680011749268, -0.150000005960464),
    c(3.12655997276306, 2.31680011749268, 0.150000005960464),
    c(3.12671995162964, 2.2772901058197, -0.103564001619816),
    c(3.12671995162964, 2.2772901058197, 0.103564001619816),
    c(3.12690997123718, 2.17127990722656, -0.0835419967770576),
    c(3.12690997123718, 2.17127990722656, 0.0835419967770576),
    c(3.13750004768372, 2.25, -0.0843750014901161),
    c(3.13750004768372, 2.25, 0.0843750014901161),
    c(3.14910006523132, 2.17045998573303, 0),
    c(3.15336990356445, 2.27552008628845, -0.158935993909836),
    c(3.15336990356445, 2.27552008628845, 0.158935993909836),
    c(3.16895008087158, 2.21117997169495, -0.11235299706459),
    c(3.16895008087158, 2.21117997169495, 0.11235299706459),
    c(3.18281006813049, 2.25, -0.0492190010845661),
    c(3.18281006813049, 2.25, 0.0492190010845661),
    c(3.20000004768372, 2.25, 0),
    c(3.20624995231628, 2.25, -0.140625),
    c(3.20624995231628, 2.25, 0.140625),
    c(3.20745992660522, 2.31251001358032, -0.119970999658108),
    c(3.20745992660522, 2.31251001358032, 0.119970999658108),
    c(3.21255993843079, 2.21042990684509, -0.0413930006325245),
    c(3.21255993843079, 2.21042990684509, 0.0413930006325245),
    c(3.21691989898682, 2.31072998046875, -0.142528995871544),
    c(3.21691989898682, 2.31072998046875, 0.142528995871544),
    c(3.23094010353088, 2.27940011024475, -0.0702759996056557),
    c(3.23094010353088, 2.27940011024475, 0.0702759996056557),
    c(3.26724004745483, 2.2781400680542, -0.025891000404954),
    c(3.26724004745483, 2.2781400680542, 0.025891000404954),
    c(3.27272009849548, 2.30776000022888, -0.0931639969348907),
    c(3.27272009849548, 2.30776000022888, 0.0931639969348907),
    c(3.27421998977661, 2.25, -0.0820309966802597),
    c(3.27421998977661, 2.25, 0.0820309966802597),
    c(3.29534006118774, 2.2770299911499, -0.10784900188446),
    c(3.29534006118774, 2.2770299911499, 0.10784900188446),
    c(3.29999995231628, 2.25, 0),
    c(3.31404995918274, 2.30330991744995, -0.131835997104645),
    c(3.31404995918274, 2.30330991744995, 0.131835997104645),
    c(3.33072996139526, 2.30984997749329, -0.0543459989130497),
    c(3.33072996139526, 2.30984997749329, 0.0543459989130497),
    c(3.33388996124268, 2.324049949646, -0.112499997019768),
    c(3.33388996124268, 2.324049949646, 0.112499997019768),
    c(3.33488988876343, 2.31701993942261, -0.0814089998602867),
    c(3.33488988876343, 2.31701993942261, 0.0814089998602867),
    c(3.34236001968384, 2.2800600528717, -0.039733998477459),
    c(3.34236001968384, 2.2800600528717, 0.039733998477459),
    c(3.35542988777161, 2.30270004272461, 0),
    c(3.35925006866455, 2.31465005874634, -0.0967160016298294),
    c(3.35925006866455, 2.31465005874634, 0.0967160016298294),
    c(3.37912011146545, 2.31658005714417, -0.0299929995089769),
    c(3.37912011146545, 2.31658005714417, 0.0299929995089769),
    c(3.38684010505676, 2.30481004714966, -0.0769039988517761),
    c(3.38684010505676, 2.30481004714966, 0.0769039988517761),
    c(3.40220999717712, 2.32644009590149, -0.0656249970197678),
    c(3.40220999717712, 2.32644009590149, 0.0656249970197678),
    c(3.40638995170593, 2.31850004196167, -0.035631999373436),
    c(3.40638995170593, 2.31850004196167, 0.035631999373436),
    c(3.40838003158569, 2.31542992591858, 0),
    c(3.42811989784241, 2.32733988761902, 0)
  )
}
