% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_glm_count.R
\name{h_glm_count}
\alias{h_glm_count}
\alias{h_glm_poisson}
\alias{h_glm_quasipoisson}
\alias{h_glm_negbin}
\title{Helper functions for Poisson models}
\usage{
h_glm_count(.var, .df_row, variables, distribution, weights)

h_glm_poisson(.var, .df_row, variables, weights)

h_glm_quasipoisson(.var, .df_row, variables, weights)

h_glm_negbin(.var, .df_row, variables, weights)
}
\arguments{
\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.df_row}{(\code{data.frame})\cr dataset that includes all the variables that are called
in \code{.var} and \code{variables}.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables, with
expected elements:
\itemize{
\item \code{arm} (\code{string})\cr group variable, for which the covariate adjusted means of multiple
groups will be summarized. Specifically, the first level of \code{arm} variable is taken as the
reference group.
\item \code{covariates} (\code{character})\cr a vector that can contain single variable names (such as
\code{"X1"}), and/or interaction terms indicated by \code{"X1 * X2"}.
\item \code{offset} (\code{numeric})\cr a numeric vector or scalar adding an offset.
}}

\item{distribution}{(\code{character})\cr a character value specifying the distribution
used in the regression (Poisson, Quasi-Poisson, negative binomial).}

\item{weights}{(\code{character})\cr a character vector specifying weights used
in averaging predictions. Number of weights must equal the number of levels included in the covariates.
Weights option passed to \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.}
}
\value{
\itemize{
\item \code{h_glm_count()} returns the results of the selected model.
}

\itemize{
\item \code{h_glm_poisson()} returns the results of a Poisson model.
}

\itemize{
\item \code{h_glm_quasipoisson()} returns the results of a Quasi-Poisson model.
}

\itemize{
\item \code{h_glm_negbin()} returns the results of a negative binomial model.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper functions that returns the results of \code{\link[stats:glm]{stats::glm()}} when Poisson or Quasi-Poisson
distributions are needed (see \code{family} parameter), or \code{\link[MASS:glm.nb]{MASS::glm.nb()}} for Negative Binomial
distributions. Link function for the GLM is \code{log}.
}
\section{Functions}{
\itemize{
\item \code{h_glm_count()}: Helper function to return the results of the
selected model (Poisson, Quasi-Poisson, negative binomial).

\item \code{h_glm_poisson()}: Helper function to return results of a Poisson model.

\item \code{h_glm_quasipoisson()}: Helper function to return results of a Quasi-Poisson model.

\item \code{h_glm_negbin()}: Helper function to return results of a negative binomial model.

}}
\seealso{
\link{summarize_glm_count}
}
\keyword{internal}
