% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{aesi_label}
\alias{aesi_label}
\title{Labels for adverse event baskets}
\usage{
aesi_label(aesi, scope = NULL)
}
\arguments{
\item{aesi}{(\code{character})\cr vector with standardized MedDRA query name (e.g. \code{SMQxxNAM}) or customized query
name (e.g. \code{CQxxNAM}).}

\item{scope}{(\code{character})\cr vector with scope of query (e.g. \code{SMQxxSC}).}
}
\value{
A \code{string} with the standard label for the AE basket.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
adae <- tern_ex_adae

# Standardized query label includes scope.
aesi_label(adae$SMQ01NAM, scope = adae$SMQ01SC)

# Customized query label.
aesi_label(adae$CQ01NAM)

}
