% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_factor.R
\name{as_factor_keep_attributes}
\alias{as_factor_keep_attributes}
\title{Conversion of a vector to a factor}
\usage{
as_factor_keep_attributes(
  x,
  x_name = deparse(substitute(x)),
  na_level = "<Missing>",
  verbose = TRUE
)
}
\arguments{
\item{x}{(\code{vector})\cr object to convert.}

\item{x_name}{(\code{string})\cr name of \code{x}.}

\item{na_level}{(\code{string})\cr the explicit missing level which should be used when converting a character vector.}

\item{verbose}{(\code{flag})\cr defaults to \code{TRUE}. It prints out warnings and messages.}
}
\value{
A \code{factor} with same attributes (except class) as \code{x}. Does not modify \code{x} if already a \code{factor}.
}
\description{
Converts \code{x} to a factor and keeps its attributes. Warns appropriately such that the user
can decide whether they prefer converting to factor manually (e.g. for full control of
factor levels).
}
\keyword{internal}
