% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ancova.R
\name{summarize_ancova}
\alias{summarize_ancova}
\alias{s_ancova}
\alias{a_ancova}
\title{Summary for analysis of covariance (\code{ANCOVA}).}
\usage{
summarize_ancova(
  lyt,
  vars,
  variables,
  conf_level,
  interaction_y = FALSE,
  interaction_item = NULL,
  var_labels,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  show_labels = "visible",
  table_names = vars,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_ancova(
  df,
  .var,
  .df_row,
  variables,
  .ref_group,
  .in_ref_col,
  conf_level,
  interaction_y = FALSE,
  interaction_item = NULL
)

a_ancova(
  df,
  .var,
  .df_row,
  variables,
  .ref_group,
  .in_ref_col,
  conf_level,
  interaction_y = FALSE,
  interaction_item = NULL
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{variables}{(named \code{list} of \code{strings})\cr list of additional analysis variables, with expected elements:
\itemize{
\item \code{arm} (\code{string})\cr group variable, for which the covariate adjusted means of multiple groups will be
summarized. Specifically, the first level of \code{arm} variable is taken as the reference group.
\item \code{covariates} (\code{character})\cr a vector that can contain single variable names (such as \code{"X1"}), and/or
interaction terms indicated by \code{"X1 * X2"}.
}}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{interaction_y}{(\code{character})\cr a selected item inside of the interaction_item column which will be used
to select the specific \code{ANCOVA} results. if the interaction is not needed, the default option is \code{FALSE}.}

\item{interaction_item}{(\code{character})\cr name of the variable that should have interactions
with arm. if the interaction is not needed, the default option is \code{NULL}.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure \emph{if
possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \code{get_stats("summarize_ancova")}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.df_row}{(\code{data.frame})\cr data set that includes all the variables that are called in \code{.var} and \code{variables}.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}
}
\value{
\itemize{
\item \code{summarize_ancova()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_ancova()} to the table layout.
}

\itemize{
\item \code{s_ancova()} returns a named list of 5 statistics:
\itemize{
\item \code{n}: Count of complete sample size for the group.
\item \code{lsmean}: Estimated marginal means in the group.
\item \code{lsmean_diff}: Difference in estimated marginal means in comparison to the reference group.
If working with the reference group, this will be empty.
\item \code{lsmean_diff_ci}: Confidence level for difference in estimated marginal means in comparison
to the reference group.
\item \code{pval}: p-value (not adjusted for multiple comparisons).
}
}

\itemize{
\item \code{a_ancova()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Summarize results of \code{ANCOVA}. This can be used to analyze multiple endpoints and/or
multiple timepoints within the same response variable \code{.var}.
}
\section{Functions}{
\itemize{
\item \code{summarize_ancova()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_ancova()}: Statistics function that produces a named list of results
of the investigated linear model.

\item \code{a_ancova()}: Formatted analysis function which is used as \code{afun} in \code{summarize_ancova()}.

}}
\examples{
basic_table() \%>\%
  split_cols_by("Species", ref_group = "setosa") \%>\%
  add_colcounts() \%>\%
  summarize_ancova(
    vars = "Petal.Length",
    variables = list(arm = "Species", covariates = NULL),
    table_names = "unadj",
    conf_level = 0.95, var_labels = "Unadjusted comparison",
    .labels = c(lsmean = "Mean", lsmean_diff = "Difference in Means")
  ) \%>\%
  summarize_ancova(
    vars = "Petal.Length",
    variables = list(arm = "Species", covariates = c("Sepal.Length", "Sepal.Width")),
    table_names = "adj",
    conf_level = 0.95, var_labels = "Adjusted comparison (covariates: Sepal.Length and Sepal.Width)"
  ) \%>\%
  build_table(iris)

}
\keyword{internal}
