% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_cols_by_groups.R
\name{combine_counts}
\alias{combine_counts}
\title{Combine Counts}
\usage{
combine_counts(fct, groups_list = NULL)
}
\arguments{
\item{fct}{(\code{factor})\cr the variable with levels which needs to be grouped.}

\item{groups_list}{(named \code{list} of \code{character})\cr specifies the new group levels via the names and the
levels that belong to it in the character vectors that are elements of the list.}
}
\value{
A \code{vector} of column counts.
}
\description{
Simplifies the estimation of column counts, especially when group combination is required.
}
\examples{
ref <- c("A: Drug X", "B: Placebo")
groups <- combine_groups(fct = DM$ARM, ref = ref)

col_counts <- combine_counts(
  fct = DM$ARM,
  groups_list = groups
)

basic_table() \%>\%
  split_cols_by_groups("ARM", groups) \%>\%
  add_colcounts() \%>\%
  analyze_vars("AGE") \%>\%
  build_table(DM, col_counts = col_counts)

ref <- "A: Drug X"
groups <- combine_groups(fct = DM$ARM, ref = ref)
col_counts <- combine_counts(
  fct = DM$ARM,
  groups_list = groups
)

basic_table() \%>\%
  split_cols_by_groups("ARM", groups) \%>\%
  add_colcounts() \%>\%
  analyze_vars("AGE") \%>\%
  build_table(DM, col_counts = col_counts)

}
\seealso{
\code{\link[=combine_groups]{combine_groups()}}
}
