% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npars.R
\name{npars}
\alias{npars}
\alias{npars.term}
\title{Number of Parameters}
\usage{
npars(x, ...)

\method{npars}{term}(x, scalar = NA, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{scalar}{A flag specifying whether to only count parameters with one term.}
}
\value{
A count of the number of parameters.
}
\description{
Gets the number of parameters of an object as returned by \code{\link[=pars]{pars()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{term}: Number of parameters of term vector
}}

\examples{
npars(as.term(c("sigma", "alpha[1]", "alpha[2]", "beta[1,1]", "beta[2,1]")))
npars(as.term(c("sigma", "alpha[1]", "alpha[2]")), scalar = TRUE)
}
\seealso{
\code{\link[=pars]{pars()}} and \code{\link[=term-vector]{term-vector()}}
}
