% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.evaluate.R
\name{sparse.evaluate}
\alias{sparse.evaluate}
\title{Evaluate the accuracy of clustering result}
\usage{
sparse.evaluate(bires, data, CER = TRUE, show = TRUE)
}
\arguments{
\item{bires}{the return value of label2()}

\item{data}{the return value of get.data()}

\item{CER}{logic value. If true, it would return CER also}

\item{show}{logic value. If true, it would print the result}
}
\value{
a list:
    \code{sparsityrate}: estimated sparsity rate;
    
    \code{correctzerorate}: correct zero rate;
    
    \code{correctonerate}: correct one rate;
    
    \code{totalincorrectrate}: total incorrect rate;
    
    \code{cerC}: CER on mode 1;
    
    \code{cerD}: CER on mode 2;
    
    \code{cerE}: CER on mode 3;
    
    \code{cerTotal}: overall CER;
    
    \code{error}: relative error.
}
\description{
Given the input tensor, perform tensor clustering and evaluate the accuracy of the clustering result.
}
\examples{
data = get.data(20,20,20,2,2,2,sparse.percent=0.1)
bires = label2(data$x,2,2,2)
sparse.evaluate(bires,data)
}
