% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEMPTED.R
\name{plot_metafeature}
\alias{plot_metafeature}
\title{Plot nonparametric smoothed mesan and error bands of meta features versus time}
\usage{
plot_metafeature(metafeature, group, coverage = 0.95, bws = NULL, nrow = 1)
}
\arguments{
\item{metafeature}{\code{metafeature_ratio} from the output of \code{\link{ratio_feature}} and
\code{\link{tempted_all}},
\code{metafeature_aggregate} from the output of
\code{\link{ratio_feature}} and \code{\link{tempted_all}},
or \code{metafeature_aggregate_est} from the output of \code{\link{ratio_feature}}.}

\item{group}{A subject by 2 data.frame with the first column for subject ID and second column for group membership.}

\item{coverage}{The coverage rate for the error band. Default is 0.95.}

\item{bws}{The smoothness parameter for the smoothing lines and error bands.
A larger value means a smoother line.
Default is NULL and calculated by function \code{np::npreg()}.}

\item{nrow}{The number of rows to plot the features used in function \code{ggplot2::facet_wrap()}.}
}
\value{
A ggplot2 object.
}
\description{
This function plot the smoothed mean and error band of meta features
grouped by a factor variable provided by the user.
}
\seealso{
Examples can be found in \code{\link{tempted_all}}, \code{\link{ratio_feature}} and \code{\link{aggregate_feature}}.
}
