% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcodeBlock.R
\docType{class}
\name{RcodeBlock}
\alias{RcodeBlock}
\title{\code{RcodeBlock}}
\description{
Specialized \code{ContentBlock} designed to embed \code{R} code in reports.
}
\examples{

## ------------------------------------------------
## Method `RcodeBlock$new`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()


## ------------------------------------------------
## Method `RcodeBlock$set_content`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$set_content("a <- 1")


## ------------------------------------------------
## Method `RcodeBlock$set_params`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$set_params(list(echo = TRUE))


## ------------------------------------------------
## Method `RcodeBlock$get_params`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$get_params()


## ------------------------------------------------
## Method `RcodeBlock$get_available_params`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$get_available_params()


## ------------------------------------------------
## Method `RcodeBlock$from_list`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$from_list(list(text = "sth", params = list()))


## ------------------------------------------------
## Method `RcodeBlock$to_list`
## ------------------------------------------------

RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$to_list()

}
\keyword{internal}
\section{Super class}{
\code{\link[teal.reporter:ContentBlock]{teal.reporter::ContentBlock}} -> \code{RcodeBlock}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RcodeBlock-new}{\code{RcodeBlock$new()}}
\item \href{#method-RcodeBlock-set_content}{\code{RcodeBlock$set_content()}}
\item \href{#method-RcodeBlock-set_params}{\code{RcodeBlock$set_params()}}
\item \href{#method-RcodeBlock-get_params}{\code{RcodeBlock$get_params()}}
\item \href{#method-RcodeBlock-get_available_params}{\code{RcodeBlock$get_available_params()}}
\item \href{#method-RcodeBlock-from_list}{\code{RcodeBlock$from_list()}}
\item \href{#method-RcodeBlock-to_list}{\code{RcodeBlock$to_list()}}
\item \href{#method-RcodeBlock-clone}{\code{RcodeBlock$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="get_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-get_content'><code>teal.reporter::ContentBlock$get_content()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-new"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{RcodeBlock} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$new(content = character(0), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{(\code{character(1)} or \code{character(0)}) a string assigned to this \code{RcodeBlock}}

\item{\code{...}}{any \code{rmarkdown} \code{R} chunk parameter and it value.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns a \code{RcodeBlock} object with no content and no parameters.
}

\subsection{Returns}{
Object of class \code{RcodeBlock}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-set_content"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-set_content}{}}}
\subsection{Method \code{set_content()}}{
Sets content of this \code{RcodeBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$set_content(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{(\code{any}) R object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$set_content("a <- 1")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-set_params"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-set_params}{}}}
\subsection{Method \code{set_params()}}{
Sets the parameters of this \code{RcodeBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$set_params(params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{(\code{list}) any \code{rmarkdown} R chunk parameter and its value.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Configures \code{rmarkdown} chunk parameters for the \code{R} code block,
influencing its rendering and execution behavior.
}

\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$set_params(list(echo = TRUE))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-get_params"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-get_params}{}}}
\subsection{Method \code{get_params()}}{
Get the parameters of this \code{RcodeBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$get_params()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character} the parameters of this \code{RcodeBlock}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$get_params()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-get_available_params"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-get_available_params}{}}}
\subsection{Method \code{get_available_params()}}{
Get available array of parameters available to this \code{RcodeBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$get_available_params()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{character} array of parameters.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$get_available_params()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-from_list}{}}}
\subsection{Method \code{from_list()}}{
Create the \code{RcodeBlock} from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$from_list(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\verb{named list}) with two fields \code{text} and \code{params}.
Use the \code{get_available_params} method to get all possible parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$from_list(list(text = "sth", params = list()))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert the \code{RcodeBlock} to a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{named list} with a text and \code{params}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{RcodeBlock <- getFromNamespace("RcodeBlock", "teal.reporter")
block <- RcodeBlock$new()
block$to_list()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RcodeBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RcodeBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RcodeBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
