% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.gene.usage}
\alias{vis.J.usage}
\alias{vis.V.usage}
\alias{vis.gene.usage}
\title{Histogram of segments usage.}
\usage{
vis.gene.usage(.data, .genes = NA, .main = "Gene usage", .ncol = 3,
  .coord.flip = F, .dodge = F, .labs = c("Gene", "Frequency"), ...)
}
\arguments{
\item{.data}{Mitcr data frame or a list with mitcr data frames.}

\item{.genes}{Gene alphabet passed to \link{geneUsage}.}

\item{.main}{Main title of the plot.}

\item{.ncol}{Number of columns in a grid of histograms if \code{.data} is a list and \code{.dodge} is F.}

\item{.coord.flip}{if T then flip coordinates.}

\item{.dodge}{If \code{.data} is a list, than if this is T plot V-usage for all data frames to the one histogram.}

\item{.labs}{Character vector of length 2 with names for x-axis and y-axis.}

\item{...}{Parameter passed to \code{geneUsage}. By default the function compute V-usage or J-usage for beta chains
w/o using read counts and w/ "Other" segments.}
}
\value{
ggplot object.
}
\description{
Plot a histogram or a grid of histograms of V- / J-usage.
}
\examples{
\dontrun{
# Load your data.
load('immdata.rda')
# Compute V-usage statistics.
imm1.vs <- geneUsage(immdata[[1]], HUMAN_TRBV)
vis.V.usage(immdata, HUMAN_TRBV, .main = 'Immdata V-usage [1]', .dodge = T)
# Plot a histogram for one data frame using all gene segment data from V.gene column.
vis.V.usage(imm1.vs, NA, .main = 'Immdata V-usage [1]')
# Plot a grid of histograms - one histogram for V-usage for each data frame in .data.
vis.V.usage(immdata, HUMAN_TRBV, .main = 'Immdata V-usage', .dodge = F, .other = F)
}
}

