% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stats.R
\name{get.inframes}
\alias{clonotypescount}
\alias{count.frames}
\alias{count.inframes}
\alias{count.outframes}
\alias{get.frames}
\alias{get.inframes}
\alias{get.outframes}
\title{In-frame / out-of-frame sequences filter.}
\usage{
get.inframes(.data, .head = 0, .coding = T)

get.outframes(.data, .head = 0)

count.inframes(.data, .head = 0, .coding = T)

count.outframes(.data, .head = 0)

get.frames(.data, .frame = c('in', 'out', 'all'), .head = 0, .coding = T)

count.frames(.data, .frame = c('in', 'out', 'all'), .head = 0, .coding = T)
}
\arguments{
\item{.data}{MiTCR data.frame or a list with mitcr data.frames.}

\item{.head}{Parameter to the head() function. Supply 0 to get all elements. \code{head} applied before subsetting, i.e.
if .head == 500, you will get in-frames from the top 500 clonotypes.}

\item{.coding}{if T then return only coding sequences, i.e. without stop-codon.}

\item{.frame}{Which *-frames to choose.}
}
\value{
Filtered data.frame or a list with such data.frames.
}
\description{
Return the given data frame with in-frame or out-of-frame sequences only. Nucleotide sequences in a column "CDR3.nucleotide.sequence" are checked if
they length are divisible by 3 (len mod 3 == 0 => in-frame, else out-of-frame)
}

