% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax_name.R
\name{tax_name}
\alias{tax_name}
\title{Get taxonomic names for a given rank}
\usage{
tax_name(
  sci,
  get,
  db = "itis",
  pref = "ncbi",
  messages = TRUE,
  query = NULL,
  ...
)
}
\arguments{
\item{sci}{(character) Vector of taxonomic names to query. required.}

\item{get}{(character) The ranks of the taxonomic name to get, see
\code{\link[=rank_ref]{rank_ref()}}. required.}

\item{db}{(character) The database to search from: 'itis', 'ncbi' or 'both'.
If 'both' both NCBI and ITIS will be queried. Result will be the union of
both. If using ncbi, we recommend getting an API key; see
\link{taxize-authentication}}

\item{pref}{(character) If db = 'both', sets the preference for the union.
Either 'ncbi' (default) or 'itis'. Currently not implemented.}

\item{messages}{(logical) If \code{TRUE} the actual taxon queried is printed
on the console.}

\item{query}{Deprecated, see \code{sci}}

\item{...}{Other arguments passed to \code{\link[=get_tsn]{get_tsn()}} or
\code{\link[=get_uid]{get_uid()}}.}
}
\value{
A data.frame with one column for every queried rank, in addition to
a column for db and queried term.
}
\description{
Get taxonomic names for a given rank
}
\note{
While \code{\link[=tax_rank]{tax_rank()}} returns the actual rank of a
taxon, \code{\link[=tax_name]{tax_name()}} searches and returns any specified rank
higher in taxonomy.
}
\section{Authentication}{

See \link{taxize-authentication} for help on authentication
}

\examples{
\dontrun{
# A case where itis and ncbi use the same names
tax_name(sci = "Helianthus annuus", get = "family", db = "itis")
tax_name(sci = "Helianthus annuus", get = "family", db = "ncbi")
tax_name(sci = "Helianthus annuus", get = c("genus","family","order"),
  db = "ncbi")

# Case where itis and ncbi use different names
tax_name(sci = "Helianthus annuus", get = "kingdom", db = "itis")
tax_name(sci = "Helianthus annuus", get = "kingdom", db = "ncbi")

# multiple rank arguments
tax_name(sci = c("Helianthus annuus","Baetis rhodani"), get = c("genus",
"kingdom"), db = "ncbi")
tax_name(sci = c("Helianthus annuus","Baetis rhodani"), get = c("genus",
"kingdom"), db = "itis")

# query both sources
tax_name(sci=c("Helianthus annuus", 'Baetis rhodani'), get=c("genus",
"kingdom"), db="both")
}
}
\seealso{
\code{\link[=classification]{classification()}}
}
