% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_colid.R
\name{get_colid}
\alias{as.colid}
\alias{as.colid.character}
\alias{as.colid.colid}
\alias{as.colid.data.frame}
\alias{as.colid.list}
\alias{as.colid.numeric}
\alias{as.data.frame.colid}
\alias{get_colid}
\alias{get_colid_}
\title{Get the Catalogue of Life ID from taxonomic names.}
\usage{
get_colid(sciname, ask = TRUE, verbose = TRUE, rows = NA)

as.colid(x, check = TRUE)

\method{as.colid}{colid}(x, check = TRUE)

\method{as.colid}{character}(x, check = TRUE)

\method{as.colid}{list}(x, check = TRUE)

\method{as.colid}{numeric}(x, check = TRUE)

\method{as.colid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{colid}(x, ...)

get_colid_(sciname, verbose = TRUE, rows = NA)
}
\arguments{
\item{sciname}{character; scientific name.}

\item{ask}{logical; should get_colid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; If TRUE the actual taxon queried is printed on the
console.}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are considered.
Note that this function still only gives back a colid class object with one to many identifiers.
See \code{\link[taxize]{get_colid_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{x}{Input to as.colid}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.colid}}}

\item{...}{Ignored}
}
\value{
A vector of unique identifiers. If a taxon is not found NA.
If more than one ID is found the function asks for user input.
}
\description{
Get the Catalogue of Life ID from taxonomic names.
}
\examples{
\dontrun{
get_colid(sciname='Poa annua')
get_colid(sciname='Pinus contorta')
get_colid(sciname='Puma concolor')
get_colid(sciname="Abudefduf saxatilis")

get_colid(c("Poa annua", "Pinus contorta"))

# specify rows to limit choices available
get_colid(sciname='Poa annua')
get_colid(sciname='Poa annua', rows=1)
get_colid(sciname='Poa annua', rows=2)
get_colid(sciname='Poa annua', rows=1:2)

# When not found
get_colid(sciname="uaudnadndj")
get_colid(c("Chironomus riparius", "uaudnadndj"))

# Convert a uid without class information to a uid class
as.colid(get_colid("Chironomus riparius")) # already a uid, returns the same
as.colid(get_colid(c("Chironomus riparius","Pinus contorta"))) # same
as.colid(8663146) # numeric
as.colid(c(8663146,19736162,18158318)) # numeric vector, length > 1
as.colid("19736162") # character
as.colid(c("8663146","19736162","18158318")) # character vector, length > 1
as.colid(list("8663146","19736162","18158318")) # list, either numeric or character
## dont check, much faster
as.colid("8663146", check=FALSE)
as.colid(8663146, check=FALSE)
as.colid(c("8663146","19736162","18158318"), check=FALSE)
as.colid(list("8663146","19736162","18158318"), check=FALSE)

(out <- as.colid(c(8663146,19736162,18158318)))
data.frame(out)
as.colid( data.frame(out) )

# Get all data back
get_colid_("Poa annua")
get_colid_("Poa annua", rows=2)
get_colid_("Poa annua", rows=1:2)
get_colid_(c("asdfadfasd","Pinus contorta"))

get_colid(sciname="Andropadus nigriceps fusciceps", rows=1)
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_colid}},
\code{\link[taxize]{get_tpsid}}, \code{\link[taxize]{get_eolid}}
}

