% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_rank.R
\name{filter_rank}
\alias{filter_rank}
\title{Get all members (descendants) of a given rank level}
\usage{
filter_rank(
  name,
  rank,
  provider = getOption("taxadb_default_provider", "itis"),
  version = latest_version(),
  collect = TRUE,
  ignore_case = TRUE,
  db = td_connect()
)
}
\arguments{
\item{name}{taxonomic scientific name (e.g. "Aves")}

\item{rank}{taxonomic rank name. (e.g. "class")}

\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{available_versions} for details.}

\item{collect}{logical, default \code{TRUE}. Should we return an in-memory
data.frame (default, usually the most convenient), or a reference to
lazy-eval table on disk (useful for very large tables on which we may
first perform subsequent filtering operations.)}

\item{ignore_case}{should we ignore case (capitalization) in matching names?
default is \code{TRUE}.}

\item{db}{a connection to the taxadb database. See details.}
}
\value{
a data.frame in the Darwin Core tabular format containing the
matching taxonomic entities.
}
\description{
Get all members (descendants) of a given rank level
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME=tempdir())
  }

filter_rank("Aves", "class")

}

}
\seealso{
Other filter_by: 
\code{\link{filter_by}()},
\code{\link{filter_common}()},
\code{\link{filter_id}()},
\code{\link{filter_name}()}
}
\concept{filter_by}
