% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R,
%   R/getter_setter_s3_generics.R, R/taxon.R, R/taxon_authority.R, R/taxonomy.R
\name{tax_author.taxa_classification}
\alias{tax_author.taxa_classification}
\alias{tax_author<-.taxa_classification}
\alias{tax_author}
\alias{tax_author<-}
\alias{tax_author.taxa_taxon}
\alias{tax_author<-.taxa_taxon}
\alias{tax_author<-.taxa_taxon_authority}
\alias{tax_author.taxa_taxon_authority}
\alias{tax_author.taxa_taxonomy}
\alias{tax_author<-.taxa_taxonomy}
\title{Set and get taxon authors}
\usage{
\method{tax_author}{taxa_classification}(x)

\method{tax_author}{taxa_classification}(x) <- value

tax_author(x)

tax_author(x) <- value

\method{tax_author}{taxa_taxon}(x)

\method{tax_author}{taxa_taxon}(x) <- value

\method{tax_author}{taxa_taxon_authority}(x) <- value

\method{tax_author}{taxa_taxon_authority}(x)

\method{tax_author}{taxa_taxonomy}(x)

\method{tax_author}{taxa_taxonomy}(x) <- value
}
\arguments{
\item{x}{An object with taxon authors.}

\item{value}{The taxon authors to set. Inputs will be coerced into a \link{character} vector.}
}
\description{
Set and get taxon authors in objects that have them, such as \link{taxon_authority} objects.
}
\examples{
x <- taxon_authority(c('Cham. & Schldl.', 'L.'),
                     date = c('1827', '1753'))
tax_author(x)
tax_author(x)[1] <- "Billy"
tax_author(x) <- tolower(tax_author(x))

}
