% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{all_names}
\alias{all_names}
\title{Return names of data in \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}}
\arguments{
\item{obj}{(\code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}) The object containing
taxon information to be queried.}

\item{tables}{This option only applies to \code{\link[=taxmap]{taxmap()}} objects. If \code{TRUE},
include the names of columns of tables in \code{obj$data}}

\item{funcs}{This option only applies to \code{\link[=taxmap]{taxmap()}} objects. If \code{TRUE},
include the names of user-definable functions in \code{obj$funcs}.}

\item{others}{This option only applies to \code{\link[=taxmap]{taxmap()}} objects. If \code{TRUE},
include the names of data in \code{obj$data} besides tables.}

\item{builtin_funcs}{This option only applies to \code{\link[=taxmap]{taxmap()}} objects. If
\code{TRUE}, include functions like \code{\link[=n_supertaxa]{n_supertaxa()}} that provide information for
each taxon.}

\item{warn}{option only applies to \code{\link[=taxmap]{taxmap()}} objects. If \code{TRUE}, warn if
there are duplicate names. Duplicate names make it unclear what data is
being referred to.}
}
\value{
\code{character}
}
\description{
Return the names of data that can be used with functions in the taxa
package that use \href{http://adv-r.had.co.nz/Computing-on-the-language.html}{non-standard evaluation} (NSE),
like \code{\link[=filter_taxa]{filter_taxa()}}.
\preformatted{
obj$all_names(tables = TRUE, funcs = TRUE,
  others = TRUE, warn = FALSE)
all_names(obj, tables = TRUE, funcs = TRUE,
  others = TRUE, warn = FALSE)}
}
\examples{
# Get the names of all data accesible by non-standard evaluation
all_names(ex_taxmap)

# Dont include the names of automatically included functions.
all_names(ex_taxmap, builtin_funcs = FALSE)

}
\seealso{
Other NSE helpers: \code{\link{data_used}},
  \code{\link{get_data}}, \code{\link{names_used}}
}
\concept{NSE helpers}
