% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depreciation_interest.R
\name{depreciation_interest}
\alias{depreciation_interest}
\title{A function to calculate the costs of medical equipment}
\usage{
depreciation_interest(
  v_replace_val,
  r_salvage_val,
  n_amortisation_period = 10,
  i_interest_rt = 0.025,
  output = c("data frame", "annuity factor", "annual cost")
)
}
\arguments{
\item{v_replace_val}{V: vervangingswaarde; replacement value}

\item{r_salvage_val}{R: restwaarde; salvage value}

\item{n_amortisation_period}{N: afschrijvingstermijn,; amortization period}

\item{i_interest_rt}{i: renteperceof ntage; interest rate}

\item{output}{Default of output is a data frame with both the annuity factor and yearly deprecation and interest costs, but the values can be selected independently}
}
\value{
A data frame with the annuity factor, yearly depreciation and interest costs, or the values independently.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A function to calculate the costs of medical equipment based on Section 3.3 of the Dutch EE guideline; k = annual depreciation and interest expense jaarlijkse afschrijvings- en rentekosten
}
\examples{
# Example usage of the depreciation_interest function
# Calculate both annuity factor and yearly depreciation and interest costs as a data frame
depreciation_interest(v_replace_val = 50000, r_salvage_val = 5000)

# Get only the annuity factor
depreciation_interest(v_replace_val = 50000, r_salvage_val = 5000, output = "annuity factor")

# Get only the annual depreciation and interest cost
depreciation_interest(v_replace_val = 50000, r_salvage_val = 5000, output = "annual cost")

}
\keyword{Generic}
\keyword{Costs}
\keyword{Equipment}
