% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskscheduleR.R
\name{taskscheduler_delete}
\alias{taskscheduler_delete}
\title{Delete a specific task which was scheduled in the Windows task scheduler.}
\usage{
taskscheduler_delete(taskname)
}
\arguments{
\item{taskname}{the name of the task to delete. See the example.}
}
\value{
the system call to schtasks /Delete
}
\description{
Delete a specific task which was scheduled in the Windows task scheduler.
}
\examples{
\dontrun{
x <- taskscheduler_ls()
x
# The field TaskName might have been different on Windows with non-english language locale
task <- x$TaskName[1] 
taskscheduler_delete(taskname = task)
}
}

